/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64BlockEndOp;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;

public class AMD64ControlFlow {
    private static void cmove(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, boolean isFloat, AMD64Assembler.ConditionFlag condition, boolean unorderedIsTrue, Value trueValue, Value falseValue, boolean isSelfEqualsCheck) {
        assert (!result.equals((Object)trueValue));
        AMD64Assembler.ConditionFlag moveCondition = isSelfEqualsCheck ? AMD64Assembler.ConditionFlag.NoParity : condition;
        AMD64Move.move(crb, masm, result, falseValue);
        AMD64ControlFlow.cmove(crb, masm, result, moveCondition, trueValue);
        if (isFloat && !isSelfEqualsCheck) {
            if (unorderedIsTrue && !AMD64ControlFlow.trueOnUnordered(condition)) {
                AMD64ControlFlow.cmove(crb, masm, result, AMD64Assembler.ConditionFlag.Parity, trueValue);
            } else if (!unorderedIsTrue && AMD64ControlFlow.trueOnUnordered(condition)) {
                AMD64ControlFlow.cmove(crb, masm, result, AMD64Assembler.ConditionFlag.Parity, falseValue);
            }
        }
    }

    private static void cmove(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, AMD64Assembler.ConditionFlag cond, Value other) {
        block10: {
            block9: {
                if (!ValueUtil.isRegister((Value)other)) break block9;
                assert (!ValueUtil.asRegister((Value)other).equals((Object)ValueUtil.asRegister((Value)result))) : "other already overwritten by previous move";
                switch ((AMD64Kind)other.getPlatformKind()) {
                    case BYTE: 
                    case WORD: 
                    case DWORD: {
                        masm.cmovl(cond, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)other));
                        break block10;
                    }
                    case QWORD: {
                        masm.cmovq(cond, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)other));
                        break block10;
                    }
                    default: {
                        throw GraalError.shouldNotReachHereUnexpectedValue(other.getPlatformKind());
                    }
                }
            }
            AMD64Address addr = (AMD64Address)crb.asAddress(other);
            switch ((AMD64Kind)other.getPlatformKind()) {
                case BYTE: 
                case WORD: 
                case DWORD: {
                    masm.cmovl(cond, ValueUtil.asRegister((Value)result), addr);
                    break;
                }
                case QWORD: {
                    masm.cmovq(cond, ValueUtil.asRegister((Value)result), addr);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue(other.getPlatformKind());
                }
            }
        }
    }

    private static void setcc(AMD64MacroAssembler masm, Value result, AMD64Assembler.ConditionFlag cond) {
        switch ((AMD64Kind)result.getPlatformKind()) {
            case BYTE: 
            case WORD: 
            case DWORD: {
                masm.setl(cond, ValueUtil.asRegister((Value)result));
                break;
            }
            case QWORD: {
                masm.setq(cond, ValueUtil.asRegister((Value)result));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue(result.getPlatformKind());
            }
        }
    }

    private static AMD64Assembler.ConditionFlag intCond(Condition cond) {
        switch (cond) {
            case EQ: {
                return AMD64Assembler.ConditionFlag.Equal;
            }
            case NE: {
                return AMD64Assembler.ConditionFlag.NotEqual;
            }
            case LT: {
                return AMD64Assembler.ConditionFlag.Less;
            }
            case LE: {
                return AMD64Assembler.ConditionFlag.LessEqual;
            }
            case GE: {
                return AMD64Assembler.ConditionFlag.GreaterEqual;
            }
            case GT: {
                return AMD64Assembler.ConditionFlag.Greater;
            }
            case BE: {
                return AMD64Assembler.ConditionFlag.BelowEqual;
            }
            case AE: {
                return AMD64Assembler.ConditionFlag.AboveEqual;
            }
            case AT: {
                return AMD64Assembler.ConditionFlag.Above;
            }
            case BT: {
                return AMD64Assembler.ConditionFlag.Below;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)cond);
    }

    private static AMD64Assembler.ConditionFlag floatCond(Condition cond) {
        switch (cond) {
            case EQ: {
                return AMD64Assembler.ConditionFlag.Equal;
            }
            case NE: {
                return AMD64Assembler.ConditionFlag.NotEqual;
            }
            case LT: {
                return AMD64Assembler.ConditionFlag.Below;
            }
            case LE: {
                return AMD64Assembler.ConditionFlag.BelowEqual;
            }
            case GE: {
                return AMD64Assembler.ConditionFlag.AboveEqual;
            }
            case GT: {
                return AMD64Assembler.ConditionFlag.Above;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)cond);
    }

    public static boolean trueOnUnordered(Condition condition) {
        return AMD64ControlFlow.trueOnUnordered(AMD64ControlFlow.floatCond(condition));
    }

    private static boolean trueOnUnordered(AMD64Assembler.ConditionFlag condition) {
        switch (condition) {
            case AboveEqual: 
            case NotEqual: 
            case Above: 
            case Less: 
            case Overflow: {
                return false;
            }
            case Equal: 
            case BelowEqual: 
            case Below: 
            case GreaterEqual: 
            case NoOverflow: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)condition);
    }

    @Opcode(value="CMOVE")
    public static final class FloatCondMoveOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FloatCondMoveOp> TYPE = LIRInstructionClass.create(FloatCondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected Value result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value trueValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value falseValue;
        private final AMD64Assembler.ConditionFlag condition;
        private final boolean unorderedIsTrue;
        private final boolean isSelfEqualsCheck;

        public FloatCondMoveOp(Variable result, Condition condition, boolean unorderedIsTrue, AllocatableValue trueValue, AllocatableValue falseValue, boolean isSelfEqualsCheck) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.floatCond(condition);
            this.unorderedIsTrue = unorderedIsTrue;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
            this.isSelfEqualsCheck = isSelfEqualsCheck;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.cmove(crb, masm, this.result, true, this.condition, this.unorderedIsTrue, this.trueValue, this.falseValue, this.isSelfEqualsCheck);
        }
    }

    @Opcode(value="CMOVE")
    public static final class CondMoveOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CondMoveOp> TYPE = LIRInstructionClass.create(CondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value trueValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST})
        protected Value falseValue;
        private final AMD64Assembler.ConditionFlag condition;

        public CondMoveOp(Variable result, Condition condition, AllocatableValue trueValue, Value falseValue) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.intCond(condition);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.cmove(crb, masm, this.result, false, this.condition, false, this.trueValue, this.falseValue, false);
        }
    }

    @Opcode(value="SETcc")
    public static final class FloatCondSetOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FloatCondSetOp> TYPE = LIRInstructionClass.create(FloatCondSetOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        private final AMD64Assembler.ConditionFlag condition;

        public FloatCondSetOp(Variable result, Condition condition) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.floatCond(condition);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.setcc(masm, this.result, this.condition);
        }
    }

    @Opcode(value="SETcc")
    public static final class CondSetOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CondSetOp> TYPE = LIRInstructionClass.create(CondSetOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        private final AMD64Assembler.ConditionFlag condition;

        public CondSetOp(Variable result, Condition condition) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = AMD64ControlFlow.intCond(condition);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64ControlFlow.setcc(masm, this.result, this.condition);
        }
    }

    public static final class HashTableSwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<HashTableSwitchOp> TYPE = LIRInstructionClass.create(HashTableSwitchOp.class);
        private final JavaConstant[] keys;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue value;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue hash;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue entryScratch;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue scratch;

        public HashTableSwitchOp(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value, AllocatableValue hash, Variable scratch, Variable entryScratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)TYPE);
            this.keys = keys;
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.value = value;
            this.hash = hash;
            this.scratch = scratch;
            this.entryScratch = entryScratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register valueReg = ValueUtil.asRegister((Value)this.value, (PlatformKind)AMD64Kind.DWORD);
            Register indexReg = ValueUtil.asRegister((Value)this.hash, (PlatformKind)AMD64Kind.DWORD);
            Register scratchReg = ValueUtil.asRegister((Value)this.scratch, (PlatformKind)AMD64Kind.QWORD);
            Register entryScratchReg = ValueUtil.asRegister((Value)this.entryScratch, (PlatformKind)AMD64Kind.QWORD);
            masm.leaq(scratchReg, new AMD64Address(AMD64.rip, 0));
            int afterLea = masm.position();
            if (this.defaultTarget != null) {
                masm.movq(entryScratchReg, new AMD64Address(scratchReg, indexReg, Stride.S8, 0));
                masm.cmplAndJcc(entryScratchReg, valueReg, AMD64Assembler.ConditionFlag.NotEqual, this.defaultTarget.label(), false);
                masm.sarq(entryScratchReg, 32);
            } else {
                masm.movslq(entryScratchReg, new AMD64Address(scratchReg, indexReg, Stride.S4, 0));
            }
            masm.addq(scratchReg, entryScratchReg);
            masm.jmp(scratchReg);
            CompilationResult.JumpTable.EntryFormat entryFormat = this.defaultTarget == null ? CompilationResult.JumpTable.EntryFormat.OFFSET_ONLY : CompilationResult.JumpTable.EntryFormat.VALUE_AND_OFFSET;
            masm.align(entryFormat.size);
            int jumpTablePos = masm.position();
            int leaDisplacementPosition = afterLea - 4;
            masm.emitInt(jumpTablePos - afterLea, leaDisplacementPosition);
            for (int i = 0; i < this.targets.length; ++i) {
                Label label = this.targets[i].label();
                if (this.defaultTarget != null) {
                    masm.emitInt(this.keys[i].asInt());
                }
                if (label.isBound()) {
                    int imm32 = label.position() - jumpTablePos;
                    masm.emitInt(imm32);
                    continue;
                }
                int offsetToJumpTableBase = masm.position() - jumpTablePos;
                label.addPatchAt(masm.position(), masm);
                masm.emitByte(0);
                masm.emitShort(offsetToJumpTableBase);
                masm.emitByte(0);
            }
            CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTablePos, 0, this.keys.length - 1, entryFormat);
            crb.compilationResult.addAnnotation(jt);
        }
    }

    public static final class RangeTableSwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<RangeTableSwitchOp> TYPE = LIRInstructionClass.create(RangeTableSwitchOp.class);
        private final int lowKey;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Use
        protected Value index;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value idxScratch;
        @LIRInstruction.Temp
        protected Value scratch;

        public RangeTableSwitchOp(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Value index, Variable scratch, Variable idxScratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)TYPE);
            this.lowKey = lowKey;
            assert (defaultTarget != null);
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.index = index;
            this.scratch = scratch;
            this.idxScratch = idxScratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register indexReg = ValueUtil.asRegister((Value)this.index, (PlatformKind)AMD64Kind.DWORD);
            Register idxScratchReg = ValueUtil.asRegister((Value)this.idxScratch, (PlatformKind)AMD64Kind.DWORD);
            Register scratchReg = ValueUtil.asRegister((Value)this.scratch, (PlatformKind)AMD64Kind.QWORD);
            if (!indexReg.equals((Object)idxScratchReg)) {
                masm.movl(idxScratchReg, indexReg);
            }
            int highKey = this.lowKey + this.targets.length - 1;
            if (this.lowKey != 0) {
                masm.subl(idxScratchReg, this.lowKey);
                masm.cmpl(idxScratchReg, highKey - this.lowKey);
            } else {
                masm.cmpl(idxScratchReg, highKey);
            }
            masm.jcc(AMD64Assembler.ConditionFlag.Above, this.defaultTarget.label());
            RangeTableSwitchOp.emitJumpTable(crb, masm, scratchReg, idxScratchReg, this.lowKey, highKey, Arrays.stream(this.targets).map(LabelRef::label));
        }

        public static void emitJumpTable(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register scratchReg, Register idxScratchReg, int lowKey, int highKey, Stream<Label> targets) {
            masm.leaq(scratchReg, new AMD64Address(AMD64.rip, 0));
            int afterLea = masm.position();
            masm.movslq(idxScratchReg, new AMD64Address(scratchReg, idxScratchReg, Stride.S4, 0));
            masm.addq(scratchReg, idxScratchReg);
            masm.jmp(scratchReg);
            masm.align(4);
            int jumpTablePos = masm.position();
            int leaDisplacementPosition = afterLea - 4;
            masm.emitInt(jumpTablePos - afterLea, leaDisplacementPosition);
            targets.forEach(label -> {
                int offsetToJumpTableBase = masm.position() - jumpTablePos;
                if (label.isBound()) {
                    int imm32 = label.position() - jumpTablePos;
                    masm.emitInt(imm32);
                } else {
                    label.addPatchAt(masm.position(), masm);
                    masm.emitByte(0);
                    masm.emitShort(offsetToJumpTableBase);
                    masm.emitByte(0);
                }
            });
            CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTablePos, lowKey, highKey, CompilationResult.JumpTable.EntryFormat.OFFSET_ONLY);
            crb.compilationResult.addAnnotation(jt);
        }
    }

    public static class StrategySwitchOp
    extends AMD64BlockEndOp {
        public static final LIRInstructionClass<StrategySwitchOp> TYPE = LIRInstructionClass.create(StrategySwitchOp.class);
        protected final Constant[] keyConstants;
        private final LabelRef[] keyTargets;
        private LabelRef defaultTarget;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue key;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue scratch;
        protected final SwitchStrategy strategy;

        public StrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, AllocatableValue scratch) {
            this(TYPE, strategy, keyTargets, defaultTarget, key, scratch);
        }

        protected StrategySwitchOp(LIRInstructionClass<? extends StrategySwitchOp> c, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, AllocatableValue scratch) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)c);
            this.strategy = strategy;
            this.keyConstants = strategy.getKeyConstants();
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
            this.key = key;
            this.scratch = scratch;
            assert (this.keyConstants.length == keyTargets.length) : Assertions.errorMessage(this.keyConstants, keyTargets);
            assert (this.keyConstants.length == strategy.keyProbabilities.length) : Assertions.errorMessage(this.keyConstants, strategy);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.strategy.run(new SwitchClosure(ValueUtil.asRegister((Value)this.key), crb, masm));
        }

        public class SwitchClosure
        extends SwitchStrategy.BaseSwitchClosure {
            protected final Register keyRegister;
            protected final CompilationResultBuilder crb;
            protected final AMD64MacroAssembler masm;

            protected SwitchClosure(Register keyRegister, CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                super(crb, masm, StrategySwitchOp.this.keyTargets, StrategySwitchOp.this.defaultTarget);
                this.keyRegister = keyRegister;
                this.crb = crb;
                this.masm = masm;
            }

            protected void emitComparison(Constant c) {
                JavaConstant jc = (JavaConstant)c;
                switch (jc.getJavaKind()) {
                    case Int: {
                        long lc = jc.asLong();
                        assert (NumUtil.isInt(lc));
                        this.masm.cmpl(this.keyRegister, (int)lc);
                        break;
                    }
                    case Long: {
                        this.masm.cmpq(this.keyRegister, (AMD64Address)this.crb.asLongConstRef(jc));
                        break;
                    }
                    case Object: {
                        AMD64Move.const2reg(this.crb, this.masm, ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch), jc, AMD64Kind.QWORD);
                        this.masm.cmpptr(this.keyRegister, ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch));
                        break;
                    }
                    default: {
                        throw new GraalError("switch only supported for int, long and object");
                    }
                }
            }

            @Override
            protected void conditionalJump(int index, Condition condition, Label target) {
                this.emitComparison(StrategySwitchOp.this.keyConstants[index]);
                this.masm.jcc(AMD64ControlFlow.intCond(condition), target);
            }
        }
    }

    public static final class FloatBranchOp
    extends BranchOp {
        public static final LIRInstructionClass<FloatBranchOp> TYPE = LIRInstructionClass.create(FloatBranchOp.class);
        protected boolean unorderedIsTrue;
        protected boolean isSelfEqualsCheck;

        public FloatBranchOp(Condition condition, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            this(condition, unorderedIsTrue, trueDestination, falseDestination, trueDestinationProbability, false);
        }

        public FloatBranchOp(Condition condition, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability, boolean isSelfEqualsCheck) {
            super(TYPE, AMD64ControlFlow.floatCond(condition), trueDestination, falseDestination, trueDestinationProbability);
            this.unorderedIsTrue = unorderedIsTrue;
            this.isSelfEqualsCheck = isSelfEqualsCheck;
        }

        @Override
        protected void jcc(AMD64MacroAssembler masm, boolean negate, LabelRef target) {
            Label label = target.label();
            Label endLabel = new Label();
            if (this.isSelfEqualsCheck) {
                assert (!this.unorderedIsTrue);
                AMD64Assembler.ConditionFlag notNaN = negate ? AMD64Assembler.ConditionFlag.Parity : AMD64Assembler.ConditionFlag.NoParity;
                masm.jcc(notNaN, label);
                masm.bind(endLabel);
            } else {
                boolean unorderedIsTrue1;
                AMD64Assembler.ConditionFlag condition1;
                AMD64Assembler.ConditionFlag conditionFlag = condition1 = negate ? this.condition.negate() : this.condition;
                boolean bl = negate ? !this.unorderedIsTrue : (unorderedIsTrue1 = this.unorderedIsTrue);
                if (unorderedIsTrue1 && !AMD64ControlFlow.trueOnUnordered(condition1)) {
                    masm.jcc(AMD64Assembler.ConditionFlag.Parity, label);
                } else if (!unorderedIsTrue1 && AMD64ControlFlow.trueOnUnordered(condition1)) {
                    masm.jccb(AMD64Assembler.ConditionFlag.Parity, endLabel);
                }
                masm.jcc(condition1, label);
                masm.bind(endLabel);
            }
        }
    }

    public static class CmpDataBranchOp
    extends BranchOp {
        public static final LIRInstructionClass<CmpDataBranchOp> TYPE = LIRInstructionClass.create(CmpDataBranchOp.class);
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        private final Constant y;

        public CmpDataBranchOp(AMD64BaseAssembler.OperandSize size, AllocatableValue x, Constant y, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            this.size = size;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Supplier<AMD64Address> applyBeforeConsumer = () -> (AMD64Address)crb.recordDataReferenceInCode(this.y, this.size.getBytes());
            if (crb.isSuccessorEdge(this.trueDestination)) {
                masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), applyBeforeConsumer, this.condition.negate(), this.falseDestination.label());
            } else if (crb.isSuccessorEdge(this.falseDestination)) {
                masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), applyBeforeConsumer, this.condition, this.trueDestination.label());
            } else if (this.trueDestinationProbability < 0.5) {
                masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), applyBeforeConsumer, this.condition.negate(), this.falseDestination.label());
                masm.jmp(this.trueDestination.label());
            } else {
                masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), applyBeforeConsumer, this.condition, this.trueDestination.label());
                masm.jmp(this.falseDestination.label());
            }
        }
    }

    public static class CmpConstBranchOp
    extends BranchOp {
        public static final LIRInstructionClass<CmpConstBranchOp> TYPE = LIRInstructionClass.create(CmpConstBranchOp.class);
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.COMPOSITE})
        protected Value x;
        private final int y;
        private final VMConstant inlinedY;
        @LIRInstruction.State
        protected LIRFrameState state;

        public CmpConstBranchOp(AMD64BaseAssembler.OperandSize size, Value x, int y, LIRFrameState state, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            this.size = size;
            this.x = x;
            this.y = y;
            this.inlinedY = null;
            this.state = state;
        }

        public CmpConstBranchOp(AMD64BaseAssembler.OperandSize size, Value x, VMConstant y, LIRFrameState state, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            this.size = size;
            this.x = x;
            this.y = -559030611;
            this.inlinedY = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            boolean inlineDataInCode = this.inlinedY != null;
            IntConsumer applyBeforeFusedPair = null;
            if (inlineDataInCode) {
                applyBeforeFusedPair = pos -> crb.recordInlineDataInCode((Constant)this.inlinedY);
            }
            if (ValueUtil.isRegister((Value)this.x)) {
                assert (this.state == null);
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
                return;
            }
            if (this.state != null) {
                IntConsumer implicitException = pos -> crb.recordImplicitException(pos, this.state);
                IntConsumer intConsumer = applyBeforeFusedPair = applyBeforeFusedPair == null ? implicitException : applyBeforeFusedPair.andThen(implicitException);
            }
            if (ValueUtil.isStackSlot((Value)this.x)) {
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            } else {
                AMD64AddressValue xAddress = (AMD64AddressValue)this.x;
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, xAddress.toAddress(), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, xAddress.toAddress(), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, xAddress.toAddress(), this.y, this.condition.negate(), this.falseDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, xAddress.toAddress(), this.y, this.condition, this.trueDestination.label(), false, inlineDataInCode, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            }
        }
    }

    public static class CmpBranchOp
    extends BranchOp
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<CmpBranchOp> TYPE = LIRInstructionClass.create(CmpBranchOp.class);
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.COMPOSITE})
        protected Value y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public CmpBranchOp(AMD64BaseAssembler.OperandSize size, AllocatableValue x, Value y, LIRFrameState state, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            this.size = size;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            IntConsumer applyBeforeFusedPair;
            if (ValueUtil.isRegister((Value)this.y)) {
                assert (this.state == null);
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                    masm.jmp(this.falseDestination.label());
                }
                return;
            }
            IntConsumer intConsumer = applyBeforeFusedPair = this.state == null ? null : pos -> crb.recordImplicitException(pos, this.state);
            if (ValueUtil.isStackSlot((Value)this.y)) {
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            } else {
                AMD64AddressValue yAddress = (AMD64AddressValue)this.y;
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.cmpAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.y instanceof AMD64AddressValue && ((AMD64AddressValue)this.y).isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class TestConstBranchOp
    extends BranchOp
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<TestConstBranchOp> TYPE = LIRInstructionClass.create(TestConstBranchOp.class);
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.COMPOSITE})
        protected Value x;
        private final int y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public TestConstBranchOp(AMD64BaseAssembler.OperandSize size, Value x, int y, LIRFrameState state, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            assert (size == AMD64BaseAssembler.OperandSize.DWORD || size == AMD64BaseAssembler.OperandSize.QWORD) : size;
            this.size = size;
            assert (x.getPlatformKind().getVectorLength() == 1) : Assertions.errorMessage(x);
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            IntConsumer applyBeforeFusedPair;
            if (ValueUtil.isRegister((Value)this.x)) {
                assert (this.state == null);
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition.negate(), this.falseDestination.label(), false);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition, this.trueDestination.label(), false);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition.negate(), this.falseDestination.label(), false);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), this.y, this.condition, this.trueDestination.label(), false);
                    masm.jmp(this.falseDestination.label());
                }
                return;
            }
            IntConsumer intConsumer = applyBeforeFusedPair = this.state == null ? null : pos -> crb.recordImplicitException(pos, this.state);
            if (ValueUtil.isStackSlot((Value)this.x)) {
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, (AMD64Address)crb.asAddress(this.x), this.y, this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            } else {
                AMD64AddressValue xAddress = (AMD64AddressValue)this.x;
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, xAddress.toAddress(), this.y, this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, xAddress.toAddress(), this.y, this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, xAddress.toAddress(), this.y, this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, xAddress.toAddress(), this.y, this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.x instanceof AMD64AddressValue && ((AMD64AddressValue)this.x).isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class TestBranchOp
    extends BranchOp
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<TestBranchOp> TYPE = LIRInstructionClass.create(TestBranchOp.class);
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.COMPOSITE})
        protected Value y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public TestBranchOp(AMD64BaseAssembler.OperandSize size, AllocatableValue x, Value y, LIRFrameState state, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            assert (size == AMD64BaseAssembler.OperandSize.WORD || size == AMD64BaseAssembler.OperandSize.DWORD || size == AMD64BaseAssembler.OperandSize.QWORD) : size;
            this.size = size;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            IntConsumer applyBeforeFusedPair;
            if (ValueUtil.isRegister((Value)this.y)) {
                assert (this.state == null);
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                    masm.jmp(this.falseDestination.label());
                }
                return;
            }
            IntConsumer intConsumer = applyBeforeFusedPair = this.state == null ? null : pos -> crb.recordImplicitException(pos, this.state);
            if (ValueUtil.isStackSlot((Value)this.y)) {
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress(this.y), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            } else {
                AMD64AddressValue yAddress = (AMD64AddressValue)this.y;
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition.negate(), this.falseDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testAndJcc(this.size, ValueUtil.asRegister((Value)this.x), yAddress.toAddress(), this.condition, this.trueDestination.label(), false, applyBeforeFusedPair);
                    masm.jmp(this.falseDestination.label());
                }
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.y instanceof AMD64AddressValue && ((AMD64AddressValue)this.y).isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class TestByteBranchOp
    extends BranchOp {
        public static final LIRInstructionClass<TestByteBranchOp> TYPE = LIRInstructionClass.create(TestByteBranchOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public TestByteBranchOp(AllocatableValue x, AllocatableValue y, Condition cond, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, AMD64ControlFlow.intCond(cond), trueDestination, falseDestination, trueDestinationProbability);
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.y)) {
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), this.condition, this.trueDestination.label(), false);
                    masm.jmp(this.falseDestination.label());
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)this.y));
                if (crb.isSuccessorEdge(this.trueDestination)) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                } else if (crb.isSuccessorEdge(this.falseDestination)) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y), this.condition, this.trueDestination.label(), false);
                } else if (this.trueDestinationProbability < 0.5) {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y), this.condition.negate(), this.falseDestination.label(), false);
                    masm.jmp(this.trueDestination.label());
                } else {
                    masm.testbAndJcc(ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y), this.condition, this.trueDestination.label(), false);
                    masm.jmp(this.falseDestination.label());
                }
            }
        }
    }

    public static class BranchOp
    extends AMD64BlockEndOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<BranchOp> TYPE = LIRInstructionClass.create(BranchOp.class);
        protected final AMD64Assembler.ConditionFlag condition;
        protected final LabelRef trueDestination;
        protected final LabelRef falseDestination;
        protected final double trueDestinationProbability;

        public BranchOp(Condition condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            this(AMD64ControlFlow.intCond(condition), trueDestination, falseDestination, trueDestinationProbability);
        }

        public BranchOp(AMD64Assembler.ConditionFlag condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            this(TYPE, condition, trueDestination, falseDestination, trueDestinationProbability);
        }

        protected BranchOp(LIRInstructionClass<? extends BranchOp> c, AMD64Assembler.ConditionFlag condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super((LIRInstructionClass<? extends AMD64BlockEndOp>)c);
            this.condition = condition;
            this.trueDestination = trueDestination;
            this.falseDestination = falseDestination;
            this.trueDestinationProbability = trueDestinationProbability;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (crb.isSuccessorEdge(this.trueDestination)) {
                this.jcc(masm, true, this.falseDestination);
            } else if (crb.isSuccessorEdge(this.falseDestination)) {
                this.jcc(masm, false, this.trueDestination);
            } else if (this.trueDestinationProbability < 0.5) {
                this.jcc(masm, true, this.falseDestination);
                masm.jmp(this.trueDestination.label());
            } else {
                this.jcc(masm, false, this.trueDestination);
                masm.jmp(this.falseDestination.label());
            }
        }

        protected void jcc(AMD64MacroAssembler masm, boolean negate, LabelRef target) {
            masm.jcc(negate ? this.condition.negate() : this.condition, target.label());
        }
    }
}

