/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/macroAssembler_x86.hpp#L200-L206", sha1="f1f7051b93fb7037a3f7baf2cfc25681979ac6dc")
public final class AMD64FloatToHalfFloatOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64FloatToHalfFloatOp> TYPE = LIRInstructionClass.create(AMD64FloatToHalfFloatOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value tmpValue;

    public AMD64FloatToHalfFloatOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.tmpValue = tool.newVariable(srcValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register tmp = ValueUtil.asRegister((Value)this.tmpValue);
        masm.vcvtps2ph(tmp, src, 4);
        masm.movdl(dst, tmp);
        masm.movswl(dst, dst);
    }
}

