/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64LIRHelper;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L1347-L1382", sha1="12a9844b6c686f0185bb738d9c0758a66b54ba7a"), @SyncPort(from="https://github.com/openjdk/jdk/blob/b3f34039fedd3c49404783ec880e1885dceb296b/src/hotspot/cpu/x86/macroAssembler_x86_sha.cpp#L32-L233", sha1="983fb75958945f5fb6b89327bd807f98b4e8c99c")})
public final class AMD64SHA1Op
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SHA1Op> TYPE = LIRInstructionClass.create(AMD64SHA1Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant upperWordMask = AMD64LIRHelper.pointerConstant(16, new int[]{0, 0, 0, -1});
    static ArrayDataPointerConstant shuffleByteFlipMask = AMD64LIRHelper.pointerConstant(16, new int[]{202182159, 134810123, 67438087, 66051});

    public AMD64SHA1Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AMD64SHA1Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.multiBlock = multiBlock;
        this.temps = new Value[]{AMD64.xmm0.asValue(), AMD64.xmm1.asValue(), AMD64.xmm2.asValue(), AMD64.xmm3.asValue(), AMD64.xmm4.asValue(), AMD64.xmm5.asValue(), AMD64.xmm6.asValue(), AMD64.xmm7.asValue(), AMD64.xmm8.asValue(), AMD64.xmm9.asValue()};
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.movq(buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.movl(ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        Register abcd = AMD64.xmm0;
        Register e0 = AMD64.xmm1;
        Register e1 = AMD64.xmm2;
        Register msg0 = AMD64.xmm3;
        Register msg1 = AMD64.xmm4;
        Register msg2 = AMD64.xmm5;
        Register msg3 = AMD64.xmm6;
        Register shufMask = AMD64.xmm7;
        Register e0Backup = AMD64.xmm8;
        Register abcdBackup = AMD64.xmm9;
        Label labelDoneHash = new Label();
        Label labelLoop0 = new Label();
        masm.movdqu(abcd, new AMD64Address(state, 0));
        masm.pinsrd(e0, new AMD64Address(state, 16), 3);
        masm.movdqu(shufMask, AMD64LIRHelper.recordExternalAddress(crb, upperWordMask));
        masm.pand(e0, shufMask);
        masm.pshufd(abcd, abcd, 27);
        masm.movdqu(shufMask, AMD64LIRHelper.recordExternalAddress(crb, shuffleByteFlipMask));
        masm.bind(labelLoop0);
        masm.movdqu(e0Backup, e0);
        masm.movdqu(abcdBackup, abcd);
        masm.movdqu(msg0, new AMD64Address(buf, 0));
        masm.pshufb(msg0, shufMask);
        masm.paddd(e0, msg0);
        masm.movdqa(e1, abcd);
        masm.sha1rnds4(abcd, e0, 0);
        masm.movdqu(msg1, new AMD64Address(buf, 16));
        masm.pshufb(msg1, shufMask);
        masm.sha1nexte(e1, msg1);
        masm.movdqa(e0, abcd);
        masm.sha1rnds4(abcd, e1, 0);
        masm.sha1msg1(msg0, msg1);
        masm.movdqu(msg2, new AMD64Address(buf, 32));
        masm.pshufb(msg2, shufMask);
        masm.sha1nexte(e0, msg2);
        masm.movdqa(e1, abcd);
        masm.sha1rnds4(abcd, e0, 0);
        masm.sha1msg1(msg1, msg2);
        masm.pxor(msg0, msg2);
        masm.movdqu(msg3, new AMD64Address(buf, 48));
        masm.pshufb(msg3, shufMask);
        masm.sha1nexte(e1, msg3);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg0, msg3);
        masm.sha1rnds4(abcd, e1, 0);
        masm.sha1msg1(msg2, msg3);
        masm.pxor(msg1, msg3);
        masm.sha1nexte(e0, msg0);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg1, msg0);
        masm.sha1rnds4(abcd, e0, 0);
        masm.sha1msg1(msg3, msg0);
        masm.pxor(msg2, msg0);
        masm.sha1nexte(e1, msg1);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg2, msg1);
        masm.sha1rnds4(abcd, e1, 1);
        masm.sha1msg1(msg0, msg1);
        masm.pxor(msg3, msg1);
        masm.sha1nexte(e0, msg2);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg3, msg2);
        masm.sha1rnds4(abcd, e0, 1);
        masm.sha1msg1(msg1, msg2);
        masm.pxor(msg0, msg2);
        masm.sha1nexte(e1, msg3);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg0, msg3);
        masm.sha1rnds4(abcd, e1, 1);
        masm.sha1msg1(msg2, msg3);
        masm.pxor(msg1, msg3);
        masm.sha1nexte(e0, msg0);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg1, msg0);
        masm.sha1rnds4(abcd, e0, 1);
        masm.sha1msg1(msg3, msg0);
        masm.pxor(msg2, msg0);
        masm.sha1nexte(e1, msg1);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg2, msg1);
        masm.sha1rnds4(abcd, e1, 1);
        masm.sha1msg1(msg0, msg1);
        masm.pxor(msg3, msg1);
        masm.sha1nexte(e0, msg2);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg3, msg2);
        masm.sha1rnds4(abcd, e0, 2);
        masm.sha1msg1(msg1, msg2);
        masm.pxor(msg0, msg2);
        masm.sha1nexte(e1, msg3);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg0, msg3);
        masm.sha1rnds4(abcd, e1, 2);
        masm.sha1msg1(msg2, msg3);
        masm.pxor(msg1, msg3);
        masm.sha1nexte(e0, msg0);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg1, msg0);
        masm.sha1rnds4(abcd, e0, 2);
        masm.sha1msg1(msg3, msg0);
        masm.pxor(msg2, msg0);
        masm.sha1nexte(e1, msg1);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg2, msg1);
        masm.sha1rnds4(abcd, e1, 2);
        masm.sha1msg1(msg0, msg1);
        masm.pxor(msg3, msg1);
        masm.sha1nexte(e0, msg2);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg3, msg2);
        masm.sha1rnds4(abcd, e0, 2);
        masm.sha1msg1(msg1, msg2);
        masm.pxor(msg0, msg2);
        masm.sha1nexte(e1, msg3);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg0, msg3);
        masm.sha1rnds4(abcd, e1, 3);
        masm.sha1msg1(msg2, msg3);
        masm.pxor(msg1, msg3);
        masm.sha1nexte(e0, msg0);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg1, msg0);
        masm.sha1rnds4(abcd, e0, 3);
        masm.sha1msg1(msg3, msg0);
        masm.pxor(msg2, msg0);
        masm.sha1nexte(e1, msg1);
        masm.movdqa(e0, abcd);
        masm.sha1msg2(msg2, msg1);
        masm.sha1rnds4(abcd, e1, 3);
        masm.pxor(msg3, msg1);
        masm.sha1nexte(e0, msg2);
        masm.movdqa(e1, abcd);
        masm.sha1msg2(msg3, msg2);
        masm.sha1rnds4(abcd, e0, 3);
        masm.sha1nexte(e1, msg3);
        masm.movdqa(e0, abcd);
        masm.sha1rnds4(abcd, e1, 3);
        masm.movdqu(msg0, e0Backup);
        masm.sha1nexte(e0, msg0);
        masm.movdqu(msg0, abcdBackup);
        masm.paddd(abcd, msg0);
        if (this.multiBlock) {
            masm.addq(buf, 64);
            masm.addl(ofs, 64);
            masm.cmplAndJcc(ofs, limit, AMD64Assembler.ConditionFlag.BelowEqual, labelLoop0, false);
            GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
            masm.movl(ValueUtil.asRegister((Value)this.resultValue), ofs);
        }
        masm.pshufd(abcd, abcd, 27);
        masm.movdqu(new AMD64Address(state, 0), abcd);
        masm.pextrd(new AMD64Address(state, 16), e0, 3);
        masm.bind(labelDoneHash);
    }
}

