/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64LIRHelper;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L1430-L1472", sha1="593a45db708f1b6a74086cf170612c1102fe56c2"), @SyncPort(from="https://github.com/openjdk/jdk/blob/8c9d091f19760deece8daf3e57add85482b9f2a7/src/hotspot/cpu/x86/macroAssembler_x86_sha.cpp#L235-L493", sha1="722bdd7519a7d7b9d9cec900af38137f1849ac4e")})
public final class AMD64SHA256Op
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SHA256Op> TYPE = LIRInstructionClass.create(AMD64SHA256Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value keyTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant k256 = AMD64LIRHelper.pointerConstant(16, new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998});
    static ArrayDataPointerConstant pshuffleByteFlipMask = AMD64LIRHelper.pointerConstant(16, new int[]{66051, 67438087, 134810123, 202182159, 66051, 67438087, 134810123, 202182159, 50462976, 185207048, -1, -1, 50462976, 185207048, -1, -1, -1, -1, 50462976, 185207048, -1, -1, 50462976, 185207048});

    public AMD64SHA256Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AMD64SHA256Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.multiBlock = multiBlock;
        this.keyTempValue = tool.newVariable(bufValue.getValueKind());
        this.temps = new Value[]{AMD64.xmm0.asValue(), AMD64.xmm1.asValue(), AMD64.xmm2.asValue(), AMD64.xmm3.asValue(), AMD64.xmm4.asValue(), AMD64.xmm5.asValue(), AMD64.xmm6.asValue(), AMD64.xmm7.asValue(), AMD64.xmm8.asValue(), AMD64.xmm9.asValue(), AMD64.xmm10.asValue()};
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.movq(buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.movl(ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        Register msg = AMD64.xmm0;
        Register state0 = AMD64.xmm1;
        Register state1 = AMD64.xmm2;
        Register msgtmp0 = AMD64.xmm3;
        Register msgtmp1 = AMD64.xmm4;
        Register msgtmp2 = AMD64.xmm5;
        Register msgtmp3 = AMD64.xmm6;
        Register msgtmp4 = AMD64.xmm7;
        Register shufMask = AMD64.xmm8;
        Register state0Backup = AMD64.xmm9;
        Register state1Backup = AMD64.xmm10;
        Label labelLoop0 = new Label();
        Register keyTemp = ValueUtil.asRegister((Value)this.keyTempValue);
        masm.movdqu(state0, new AMD64Address(state, 0));
        masm.movdqu(state1, new AMD64Address(state, 16));
        masm.pshufd(state0, state0, 177);
        masm.pshufd(state1, state1, 27);
        masm.movdqa(msgtmp4, state0);
        masm.palignr(state0, state1, 8);
        masm.pblendw(state1, msgtmp4, 240);
        masm.movdqu(shufMask, AMD64LIRHelper.recordExternalAddress(crb, pshuffleByteFlipMask));
        masm.leaq(keyTemp, AMD64LIRHelper.recordExternalAddress(crb, k256));
        masm.bind(labelLoop0);
        masm.movdqu(state0Backup, state0);
        masm.movdqu(state1Backup, state1);
        masm.movdqu(msg, new AMD64Address(buf, 0));
        masm.pshufb(msg, shufMask);
        masm.movdqa(msgtmp0, msg);
        masm.paddd(msg, new AMD64Address(keyTemp, 0));
        masm.sha256rnds2(state1, state0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.movdqu(msg, new AMD64Address(buf, 16));
        masm.pshufb(msg, shufMask);
        masm.movdqa(msgtmp1, msg);
        masm.paddd(msg, new AMD64Address(keyTemp, 16));
        masm.sha256rnds2(state1, state0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp0, msgtmp1);
        masm.movdqu(msg, new AMD64Address(buf, 32));
        masm.pshufb(msg, shufMask);
        masm.movdqa(msgtmp2, msg);
        masm.paddd(msg, new AMD64Address(keyTemp, 32));
        masm.sha256rnds2(state1, state0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp1, msgtmp2);
        masm.movdqu(msg, new AMD64Address(buf, 48));
        masm.pshufb(msg, shufMask);
        masm.movdqa(msgtmp3, msg);
        masm.paddd(msg, new AMD64Address(keyTemp, 48));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp3);
        masm.palignr(msgtmp4, msgtmp2, 4);
        masm.paddd(msgtmp0, msgtmp4);
        masm.sha256msg2(msgtmp0, msgtmp3);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp2, msgtmp3);
        masm.movdqa(msg, msgtmp0);
        masm.paddd(msg, new AMD64Address(keyTemp, 64));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp0);
        masm.palignr(msgtmp4, msgtmp3, 4);
        masm.paddd(msgtmp1, msgtmp4);
        masm.sha256msg2(msgtmp1, msgtmp0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp3, msgtmp0);
        masm.movdqa(msg, msgtmp1);
        masm.paddd(msg, new AMD64Address(keyTemp, 80));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp1);
        masm.palignr(msgtmp4, msgtmp0, 4);
        masm.paddd(msgtmp2, msgtmp4);
        masm.sha256msg2(msgtmp2, msgtmp1);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp0, msgtmp1);
        masm.movdqa(msg, msgtmp2);
        masm.paddd(msg, new AMD64Address(keyTemp, 96));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp2);
        masm.palignr(msgtmp4, msgtmp1, 4);
        masm.paddd(msgtmp3, msgtmp4);
        masm.sha256msg2(msgtmp3, msgtmp2);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp1, msgtmp2);
        masm.movdqa(msg, msgtmp3);
        masm.paddd(msg, new AMD64Address(keyTemp, 112));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp3);
        masm.palignr(msgtmp4, msgtmp2, 4);
        masm.paddd(msgtmp0, msgtmp4);
        masm.sha256msg2(msgtmp0, msgtmp3);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp2, msgtmp3);
        masm.movdqa(msg, msgtmp0);
        masm.paddd(msg, new AMD64Address(keyTemp, 128));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp0);
        masm.palignr(msgtmp4, msgtmp3, 4);
        masm.paddd(msgtmp1, msgtmp4);
        masm.sha256msg2(msgtmp1, msgtmp0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp3, msgtmp0);
        masm.movdqa(msg, msgtmp1);
        masm.paddd(msg, new AMD64Address(keyTemp, 144));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp1);
        masm.palignr(msgtmp4, msgtmp0, 4);
        masm.paddd(msgtmp2, msgtmp4);
        masm.sha256msg2(msgtmp2, msgtmp1);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp0, msgtmp1);
        masm.movdqa(msg, msgtmp2);
        masm.paddd(msg, new AMD64Address(keyTemp, 160));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp2);
        masm.palignr(msgtmp4, msgtmp1, 4);
        masm.paddd(msgtmp3, msgtmp4);
        masm.sha256msg2(msgtmp3, msgtmp2);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp1, msgtmp2);
        masm.movdqa(msg, msgtmp3);
        masm.paddd(msg, new AMD64Address(keyTemp, 176));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp3);
        masm.palignr(msgtmp4, msgtmp2, 4);
        masm.paddd(msgtmp0, msgtmp4);
        masm.sha256msg2(msgtmp0, msgtmp3);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp2, msgtmp3);
        masm.movdqa(msg, msgtmp0);
        masm.paddd(msg, new AMD64Address(keyTemp, 192));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp0);
        masm.palignr(msgtmp4, msgtmp3, 4);
        masm.paddd(msgtmp1, msgtmp4);
        masm.sha256msg2(msgtmp1, msgtmp0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.sha256msg1(msgtmp3, msgtmp0);
        masm.movdqa(msg, msgtmp1);
        masm.paddd(msg, new AMD64Address(keyTemp, 208));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp1);
        masm.palignr(msgtmp4, msgtmp0, 4);
        masm.paddd(msgtmp2, msgtmp4);
        masm.sha256msg2(msgtmp2, msgtmp1);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.movdqa(msg, msgtmp2);
        masm.paddd(msg, new AMD64Address(keyTemp, 224));
        masm.sha256rnds2(state1, state0);
        masm.movdqa(msgtmp4, msgtmp2);
        masm.palignr(msgtmp4, msgtmp1, 4);
        masm.paddd(msgtmp3, msgtmp4);
        masm.sha256msg2(msgtmp3, msgtmp2);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.movdqa(msg, msgtmp3);
        masm.paddd(msg, new AMD64Address(keyTemp, 240));
        masm.sha256rnds2(state1, state0);
        masm.pshufd(msg, msg, 14);
        masm.sha256rnds2(state0, state1);
        masm.movdqu(msg, state0Backup);
        masm.paddd(state0, msg);
        masm.movdqu(msg, state1Backup);
        masm.paddd(state1, msg);
        if (this.multiBlock) {
            masm.addq(buf, 64);
            masm.addl(ofs, 64);
            masm.cmplAndJcc(ofs, limit, AMD64Assembler.ConditionFlag.BelowEqual, labelLoop0, false);
            GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
            masm.movl(ValueUtil.asRegister((Value)this.resultValue), ofs);
        }
        masm.pshufd(state0, state0, 27);
        masm.pshufd(state1, state1, 177);
        masm.movdqa(msgtmp4, state0);
        masm.pblendw(state0, state1, 240);
        masm.palignr(state1, msgtmp4, 8);
        masm.movdqu(new AMD64Address(state, 0), state0);
        masm.movdqu(new AMD64Address(state, 16), state1);
    }
}

