/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64VectorClearOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64VectorClearOp> TYPE = LIRInstructionClass.create(AMD64VectorClearOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;

    public AMD64VectorClearOp(AllocatableValue result) {
        this(TYPE, result);
    }

    protected AMD64VectorClearOp(LIRInstructionClass<? extends AMD64VectorClearOp> c, AllocatableValue result) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
        this.result = result;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
        Register register = ValueUtil.asRegister((Value)this.result);
        switch (kind.getScalar()) {
            case SINGLE: {
                AMD64Assembler.VexRVMOp.VXORPS.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
                break;
            }
            case DOUBLE: {
                AMD64Assembler.VexRVMOp.VXORPD.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
                break;
            }
            default: {
                AMD64Assembler.VexRVMOp.VPXOR.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, register, register, register);
            }
        }
    }
}

