/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public final class AMD64VectorCompareOp
extends AMD64VectorInstruction {
    public static final LIRInstructionClass<AMD64VectorCompareOp> TYPE = LIRInstructionClass.create(AMD64VectorCompareOp.class);
    @Opcode
    private final AMD64Assembler.VexRMOp opcode;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue x;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
    protected AllocatableValue y;

    public AMD64VectorCompareOp(AMD64Assembler.VexRMOp opcode, AllocatableValue x, AllocatableValue y) {
        this(opcode, AVXKind.AVXSize.XMM, x, y);
    }

    public AMD64VectorCompareOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue x, AllocatableValue y) {
        super(TYPE, size);
        this.opcode = opcode;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (ValueUtil.isRegister((Value)this.y)) {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        } else {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
        }
    }
}

