/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.constopt;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.constopt.UseEntry;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

class DefUseTree {
    private final StandardOp.LoadConstantOp instruction;
    private final BasicBlock<?> block;
    private final List<UseEntry> uses;

    DefUseTree(LIRInstruction instruction, BasicBlock<?> block) {
        assert (StandardOp.LoadConstantOp.isLoadConstantOp(instruction)) : "Not a LoadConstantOp: " + String.valueOf(instruction);
        this.instruction = StandardOp.LoadConstantOp.asLoadConstantOp(instruction);
        this.block = block;
        this.uses = new ArrayList<UseEntry>();
    }

    public Variable getVariable() {
        return LIRValueUtil.asVariable((Value)this.instruction.getResult());
    }

    public Constant getConstant() {
        return this.instruction.getConstant();
    }

    public LIRInstruction getInstruction() {
        return (LIRInstruction)((Object)this.instruction);
    }

    public BasicBlock<?> getBlock() {
        return this.block;
    }

    public String toString() {
        return "DefUseTree [" + String.valueOf(this.instruction) + "|" + String.valueOf(this.block) + "," + String.valueOf(this.uses) + "]";
    }

    public void addUsage(BasicBlock<?> b, LIRInstruction inst, Value value) {
        this.uses.add(new UseEntry(b, inst, value));
    }

    public int usageCount() {
        return this.uses.size();
    }

    public void forEach(Consumer<? super UseEntry> action) {
        this.uses.forEach(action);
    }
}

