/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.dfa;

import java.util.ArrayList;
import java.util.EnumSet;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.InstructionStateProcedure;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.ValueConsumer;
import jdk.graal.compiler.lir.dfa.UniqueWorkList;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.util.ValueSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public abstract class LocationMarker<S extends ValueSet<S>> {
    private final LIR lir;
    private final BlockMap<S> liveInMap;
    private final BlockMap<S> liveOutMap;
    protected final FrameMap frameMap;
    private static final EnumSet<LIRInstruction.OperandFlag> REGISTER_FLAG_SET = EnumSet.of(LIRInstruction.OperandFlag.REG);
    private S currentSet;
    InstructionStateProcedure stateConsumer = new InstructionStateProcedure(){

        @Override
        public void doState(LIRInstruction inst, LIRFrameState info) {
            LocationMarker.this.processState(inst, info, LocationMarker.this.currentSet);
        }
    };
    ValueConsumer useConsumer = new ValueConsumer(){

        @Override
        public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (LocationMarker.this.shouldProcessValue(operand)) {
                Value value = LIRValueUtil.uncast(operand);
                DebugContext debug = LocationMarker.this.lir.getDebug();
                if (debug.isLogEnabled()) {
                    if (!value.equals((Object)operand)) {
                        debug.log("changing operand from %s to %s", (Object)operand, (Object)value);
                    }
                    debug.log("set operand: %s", value);
                }
                ((ValueSet)LocationMarker.this.currentSet).put(value);
            }
        }
    };
    ValueConsumer defConsumer = new ValueConsumer(){

        @Override
        public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (LocationMarker.this.shouldProcessValue(operand)) {
                DebugContext debug = LocationMarker.this.lir.getDebug();
                if (debug.isLogEnabled()) {
                    debug.log("clear operand: %s", operand);
                }
                ((ValueSet)LocationMarker.this.currentSet).remove(operand);
            } else assert (ValueUtil.isIllegal((Value)operand) || !operand.getValueKind().equals((Object)LIRKind.Illegal) || mode == LIRInstruction.OperandMode.TEMP) : String.format("Illegal PlatformKind is only allowed for TEMP mode: %s, %s", new Object[]{operand, mode});
        }
    };

    protected LocationMarker(LIR lir, FrameMap frameMap) {
        this.lir = lir;
        this.frameMap = frameMap;
        this.liveInMap = new BlockMap(lir.getControlFlowGraph());
        this.liveOutMap = new BlockMap(lir.getControlFlowGraph());
    }

    protected abstract S newLiveValueSet();

    protected abstract boolean shouldProcessValue(Value var1);

    protected abstract void processState(LIRInstruction var1, LIRFrameState var2, S var3);

    void build() {
        BasicBlock[] blocks = this.lir.getControlFlowGraph().getBlocks();
        UniqueWorkList worklist = new UniqueWorkList(blocks.length);
        for (int i = blocks.length - 1; i >= 0; --i) {
            worklist.add(blocks[i]);
        }
        for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
            this.liveInMap.put(block, this.newLiveValueSet());
        }
        while (!worklist.isEmpty()) {
            Object block = worklist.poll();
            this.processBlock((BasicBlock<?>)block, worklist);
        }
    }

    private boolean updateOutBlock(BasicBlock<?> block) {
        ValueSet union = this.newLiveValueSet();
        for (int i = 0; i < block.getSuccessorCount(); ++i) {
            Object succ = block.getSuccessorAt(i);
            union.putAll((ValueSet)((ValueSet)this.liveInMap.get((BasicBlock<?>)succ)));
        }
        ValueSet outSet = (ValueSet)this.liveOutMap.get(block);
        if (outSet == null || !union.equals(outSet)) {
            this.liveOutMap.put(block, union);
            return true;
        }
        return false;
    }

    private void processBlock(BasicBlock<?> block, UniqueWorkList worklist) {
        if (this.updateOutBlock(block)) {
            DebugContext debug = this.lir.getDebug();
            try (Indent indent = debug.logAndIndent("handle block %s", block);){
                int i;
                this.currentSet = ((ValueSet)this.liveOutMap.get(block)).copy();
                ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
                for (i = instructions.size() - 1; i >= 0; --i) {
                    LIRInstruction inst = instructions.get(i);
                    this.processInstructionBottomUp(inst);
                }
                this.liveInMap.put(block, this.currentSet);
                this.currentSet = null;
                for (i = 0; i < block.getPredecessorCount(); ++i) {
                    Object b = block.getPredecessorAt(i);
                    worklist.add((BasicBlock<?>)b);
                }
            }
        }
    }

    private void processInstructionBottomUp(LIRInstruction op) {
        DebugContext debug = this.lir.getDebug();
        try (Indent indent = debug.logAndIndent("handle op %d, %s", op.id(), (Object)op);){
            op.visitEachOutput(this.defConsumer);
            op.visitEachTemp(this.defConsumer);
            if (this.frameMap != null && op.destroysCallerSavedRegisters()) {
                for (Register reg : this.frameMap.getRegisterConfig().getCallerSaveRegisters()) {
                    PlatformKind kind = this.frameMap.getTarget().arch.getLargestStorableKind(reg.getRegisterCategory());
                    this.defConsumer.visitValue((Value)reg.asValue((ValueKind)LIRKind.value(kind)), LIRInstruction.OperandMode.TEMP, REGISTER_FLAG_SET);
                }
            }
            op.visitEachAlive(this.useConsumer);
            op.visitEachState(this.useConsumer);
            op.forEachState(this.stateConsumer);
            op.visitEachInput(this.useConsumer);
        }
        catch (GraalError e) {
            throw e.addContext("lir instruction", "@" + op.id() + " " + op.getClass().getName() + " " + String.valueOf(op));
        }
    }
}

