/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.dfa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.dfa.LocationMarker;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.AllocationPhase;
import jdk.graal.compiler.lir.util.IndexedValueMap;
import jdk.graal.compiler.lir.util.ValueSet;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public final class MarkBasePointersPhase
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        new Marker(lirGenRes.getLIR(), null).build();
    }

    private static final class Marker
    extends LocationMarker<BasePointersSet> {
        private Marker(LIR lir, FrameMap frameMap) {
            super(lir, frameMap);
        }

        @Override
        protected BasePointersSet newLiveValueSet() {
            return new BasePointersSet();
        }

        @Override
        protected boolean shouldProcessValue(Value operand) {
            ValueKind kind = operand.getValueKind();
            if (kind instanceof LIRKind) {
                return ((LIRKind)kind).isDerivedReference();
            }
            return false;
        }

        @Override
        protected void processState(LIRInstruction op, LIRFrameState info, BasePointersSet values) {
            info.setLiveBasePointers(values.getMap());
        }

        private final class BasePointersSet
        extends ValueSet<BasePointersSet> {
            private final Map<Integer, Set<Value>> baseDerivedRefs;

            BasePointersSet() {
                this.baseDerivedRefs = new HashMap<Integer, Set<Value>>();
            }

            private BasePointersSet(BasePointersSet other) {
                this.baseDerivedRefs = new HashMap<Integer, Set<Value>>(other.baseDerivedRefs.size());
                for (Map.Entry<Integer, Set<Value>> entry : other.baseDerivedRefs.entrySet()) {
                    HashSet s = new HashSet(entry.getValue());
                    this.baseDerivedRefs.put(entry.getKey(), s);
                }
            }

            @Override
            public BasePointersSet copy() {
                return new BasePointersSet(this);
            }

            private boolean verifyDerivedRefs(Value derivedRef, int base) {
                for (Map.Entry<Integer, Set<Value>> entry : this.baseDerivedRefs.entrySet()) {
                    Set<Value> s = entry.getValue();
                    if (!s.contains(derivedRef) || base == entry.getKey()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void put(Value v) {
                Variable base = LIRValueUtil.asVariable((Value)((LIRKind)v.getValueKind(LIRKind.class)).getDerivedReferenceBase());
                assert (!((LIRKind)base.getValueKind(LIRKind.class)).isValue());
                Set<Value> derivedRefs = this.baseDerivedRefs.get(base.index);
                assert (this.verifyDerivedRefs(v, base.index));
                if (derivedRefs == null) {
                    HashSet<Value> s = new HashSet<Value>();
                    s.add(v);
                    this.baseDerivedRefs.put(base.index, s);
                } else {
                    derivedRefs.add(v);
                }
            }

            @Override
            public void putAll(BasePointersSet v) {
                for (Map.Entry<Integer, Set<Value>> entry : v.baseDerivedRefs.entrySet()) {
                    Integer k = entry.getKey();
                    Set<Value> derivedRefsOther = entry.getValue();
                    Set<Value> derivedRefs = this.baseDerivedRefs.get(k);
                    if (derivedRefs == null) {
                        HashSet<Value> s = new HashSet<Value>(derivedRefsOther);
                        this.baseDerivedRefs.put(k, s);
                        continue;
                    }
                    derivedRefs.addAll(derivedRefsOther);
                }
            }

            @Override
            public void remove(Value v) {
                Variable base = LIRValueUtil.asVariable((Value)((LIRKind)v.getValueKind(LIRKind.class)).getDerivedReferenceBase());
                assert (!((LIRKind)base.getValueKind(LIRKind.class)).isValue());
                Set<Value> derivedRefs = this.baseDerivedRefs.get(base.index);
                if (derivedRefs == null) {
                    return;
                }
                if (derivedRefs.contains(v)) {
                    derivedRefs.remove(v);
                    if (derivedRefs.isEmpty()) {
                        this.baseDerivedRefs.remove(base.index);
                    }
                }
            }

            private IndexedValueMap getMap() {
                IndexedValueMap result = new IndexedValueMap();
                for (Set<Value> entry : this.baseDerivedRefs.values()) {
                    if (entry.isEmpty()) continue;
                    Value v = entry.iterator().next();
                    Variable base = LIRValueUtil.asVariable((Value)((LIRKind)v.getValueKind(LIRKind.class)).getDerivedReferenceBase());
                    result.put(base.index, (Value)base);
                }
                return result;
            }

            public boolean equals(Object obj) {
                if (obj instanceof BasePointersSet) {
                    BasePointersSet other = (BasePointersSet)obj;
                    return this.baseDerivedRefs.equals(other.baseDerivedRefs);
                }
                return false;
            }

            public int hashCode() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("[BasePointersSet] baseDerivedRefs map: {");
                boolean mapHaveElement = false;
                for (Map.Entry<Integer, Set<Value>> entry : this.baseDerivedRefs.entrySet()) {
                    sb.append(entry.getKey());
                    sb.append(": (");
                    boolean setHaveElement = false;
                    for (Value v : entry.getValue()) {
                        sb.append(String.valueOf(v) + ",");
                        setHaveElement = true;
                    }
                    if (setHaveElement) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append("),");
                    mapHaveElement = true;
                }
                if (mapHaveElement) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("}");
                return sb.toString();
            }
        }
    }
}

