/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.dfa;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.ValueConsumer;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.ReferenceMapBuilder;
import jdk.graal.compiler.lir.util.IndexedValueMap;
import jdk.graal.compiler.lir.util.ValueSet;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

final class RegStackValueSet
extends ValueSet<RegStackValueSet> {
    private final FrameMap frameMap;
    private final IndexedValueMap registers;
    private final IndexedValueMap stack;
    private HashMap<Integer, Value> extraStack;

    RegStackValueSet(FrameMap frameMap) {
        this.frameMap = frameMap;
        this.registers = new IndexedValueMap();
        this.stack = new IndexedValueMap();
    }

    private RegStackValueSet(FrameMap frameMap, RegStackValueSet s) {
        this.frameMap = frameMap;
        this.registers = new IndexedValueMap(s.registers);
        this.stack = new IndexedValueMap(s.stack);
        if (s.extraStack != null) {
            this.extraStack = new HashMap<Integer, Value>(s.extraStack);
        }
    }

    @Override
    public RegStackValueSet copy() {
        return new RegStackValueSet(this.frameMap, this);
    }

    @Override
    public void put(Value v) {
        if (!RegStackValueSet.shouldProcessValue(v)) {
            return;
        }
        if (ValueUtil.isRegister((Value)v)) {
            int index = ValueUtil.asRegister((Value)v).number;
            this.registers.put(index, v);
        } else if (ValueUtil.isStackSlot((Value)v)) {
            int index = this.frameMap.offsetForStackSlot(ValueUtil.asStackSlot((Value)v));
            assert (NumUtil.assertNonNegativeInt(index));
            if (index % 4 == 0) {
                this.stack.put(index / 4, v);
            } else {
                if (this.extraStack == null) {
                    this.extraStack = new HashMap();
                }
                this.extraStack.put(index, v);
            }
        }
    }

    @Override
    public void putAll(RegStackValueSet v) {
        this.registers.putAll(v.registers);
        this.stack.putAll(v.stack);
        if (v.extraStack != null) {
            if (this.extraStack == null) {
                this.extraStack = new HashMap();
            }
            this.extraStack.putAll(v.extraStack);
        }
    }

    @Override
    public void remove(Value v) {
        if (!RegStackValueSet.shouldProcessValue(v)) {
            return;
        }
        if (ValueUtil.isRegister((Value)v)) {
            int index = ValueUtil.asRegister((Value)v).number;
            RegStackValueSet.guaranteeEquals(v, this.registers.get(index));
            this.registers.put(index, null);
        } else if (ValueUtil.isStackSlot((Value)v)) {
            int index = this.frameMap.offsetForStackSlot(ValueUtil.asStackSlot((Value)v));
            assert (NumUtil.assertNonNegativeInt(index));
            if (index % 4 == 0) {
                RegStackValueSet.guaranteeEquals(v, this.stack.get(index / 4));
                this.stack.put(index / 4, null);
            } else if (this.extraStack != null) {
                RegStackValueSet.guaranteeEquals(v, this.extraStack.get(index));
                this.extraStack.remove(index);
            }
        }
    }

    private static void guaranteeEquals(Value v1, Value v2) {
        if (v1 == null || v2 == null || v1.equals((Object)v2)) {
            return;
        }
        if (!LIRValueUtil.uncast(v1).equals((Object)LIRValueUtil.uncast(v2))) {
            throw new GraalError("mismatched definition: %s != %s", v1, v2);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegStackValueSet) {
            RegStackValueSet other = (RegStackValueSet)obj;
            return this.registers.equals(other.registers) && this.stack.equals(other.stack) && Objects.equals(this.extraStack, other.extraStack);
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static boolean shouldProcessValue(Value v) {
        return ValueUtil.isRegister((Value)v) || !LIRKind.isValue(v);
    }

    public void addLiveValues(final ReferenceMapBuilder refMap) {
        ValueConsumer addLiveValue = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                refMap.addLiveValue(value);
            }
        };
        this.registers.visitEach(null, null, null, addLiveValue);
        this.stack.visitEach(null, null, null, addLiveValue);
        if (this.extraStack != null) {
            for (Value v : this.extraStack.values()) {
                refMap.addLiveValue(v);
            }
        }
    }

    public String toString() {
        return "registers: " + this.registers.toString() + "\nstack: " + this.stack.toString();
    }
}

