/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.gen;

import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterConfig;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class LIRGenerationResult {
    private final LIR lir;
    private final FrameMapBuilder frameMapBuilder;
    private FrameMap frameMap;
    private final RegisterAllocationConfig registerAllocationConfig;
    private final CallingConvention callingConvention;
    private boolean hasForeignCall;
    private CompilationIdentifier compilationId;
    private EconomicMap<LIRInstruction, String> comments;

    public LIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig, CallingConvention callingConvention) {
        this.lir = lir;
        this.frameMapBuilder = frameMapBuilder;
        this.registerAllocationConfig = registerAllocationConfig;
        this.callingConvention = callingConvention;
        this.compilationId = compilationId;
    }

    public RegisterAllocationConfig getRegisterAllocationConfig() {
        return this.registerAllocationConfig;
    }

    public final void setComment(LIRInstruction op, String comment) {
        DebugContext debug = this.lir.getDebug();
        if (debug.isDumpEnabled(1)) {
            if (this.comments == null) {
                this.comments = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            }
            this.comments.put((Object)op, (Object)comment);
        }
    }

    public final String getComment(LIRInstruction op) {
        if (this.comments == null) {
            return null;
        }
        return (String)this.comments.get((Object)op);
    }

    public CallingConvention getCallingConvention() {
        return this.callingConvention;
    }

    public final FrameMapBuilder getFrameMapBuilder() {
        assert (this.frameMap == null) : "getFrameMapBuilder() can only be used before calling buildFrameMap()!";
        return this.frameMapBuilder;
    }

    public void buildFrameMap() {
        assert (this.frameMap == null) : "buildFrameMap() can only be called once!";
        this.frameMap = this.frameMapBuilder.buildFrameMap(this);
    }

    public FrameMap getFrameMap() {
        assert (this.frameMap != null) : "getFrameMap() can only be used after calling buildFrameMap()!";
        return this.frameMap;
    }

    public final RegisterConfig getRegisterConfig() {
        return this.frameMapBuilder.getRegisterConfig();
    }

    public LIR getLIR() {
        return this.lir;
    }

    public boolean hasForeignCall() {
        return this.hasForeignCall;
    }

    public final void setForeignCall(boolean hasForeignCall) {
        this.hasForeignCall = hasForeignCall;
    }

    public String getCompilationUnitName() {
        if (this.compilationId == null || this.compilationId == CompilationIdentifier.INVALID_COMPILATION_ID) {
            return "<unknown>";
        }
        return this.compilationId.toString(CompilationIdentifier.Verbosity.NAME);
    }

    public final int getFirstInsertPosition() {
        return 1;
    }

    public boolean emitIndirectTargetBranchMarkers() {
        return false;
    }
}

