/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.gen;

import java.util.EnumSet;
import jdk.graal.compiler.asm.VectorSize;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public interface LIRGeneratorTool
extends CoreProviders,
DiagnosticLIRGeneratorTool,
ValueKindFactory<LIRKind> {
    public ArithmeticLIRGeneratorTool getArithmetic();

    public BarrierSetLIRGeneratorTool getBarrierSet();

    public TargetDescription target();

    public BasicBlock<?> getCurrentBlock();

    public LIRGenerationResult getResult();

    public RegisterConfig getRegisterConfig();

    public MoveFactory getMoveFactory();

    public MoveFactory getSpillMoveFactory();

    public boolean canInlineConstant(Constant var1);

    public boolean mayEmbedConstantLoad(Constant var1);

    public Value emitConstant(LIRKind var1, Constant var2);

    public Value emitJavaConstant(JavaConstant var1);

    public <K extends ValueKind<K>> K toRegisterKind(K var1);

    public AllocatableValue emitLoadConstant(ValueKind<?> var1, Constant var2);

    public void emitNullCheck(Value var1, LIRFrameState var2);

    public Variable emitLogicCompareAndSwap(LIRKind var1, Value var2, Value var3, Value var4, Value var5, Value var6, MemoryOrderMode var7, BarrierType var8);

    public Value emitValueCompareAndSwap(LIRKind var1, Value var2, Value var3, Value var4, MemoryOrderMode var5, BarrierType var6);

    public Value emitAtomicReadAndAdd(LIRKind var1, Value var2, Value var3);

    public Value emitAtomicReadAndWrite(LIRKind var1, Value var2, Value var3, BarrierType var4);

    public void emitDeoptimize(Value var1, Value var2, LIRFrameState var3);

    public Variable emitForeignCall(ForeignCallLinkage var1, LIRFrameState var2, Value ... var3);

    public Variable newVariable(ValueKind<?> var1);

    public Variable emitMove(Value var1);

    public Variable emitMove(ValueKind<?> var1, Value var2);

    public void emitMove(AllocatableValue var1, Value var2);

    public Variable emitReadRegister(Register var1, ValueKind<?> var2);

    public void emitWriteRegister(Register var1, Value var2, ValueKind<?> var3);

    public void emitMoveConstant(AllocatableValue var1, Constant var2);

    public Variable emitAddress(AllocatableValue var1);

    public void emitMembar(int var1);

    public void emitUnwind(Value var1);

    default public void emitHalt() {
        throw GraalError.unimplemented("Halt operation is not implemented on this architecture");
    }

    public void emitReturn(JavaKind var1, Value var2);

    public AllocatableValue asAllocatable(Value var1);

    default public AllocatableValue addressAsAllocatableInteger(Value value) {
        return this.asAllocatable(value);
    }

    public <I extends LIRInstruction> I append(I var1);

    public void emitJump(LabelRef var1);

    public Variable emitConditionalMove(PlatformKind var1, Value var2, Value var3, Condition var4, boolean var5, Value var6, Value var7);

    public Variable emitIntegerTestMove(Value var1, Value var2, Value var3, Value var4);

    public Variable emitReverseBytes(Value var1);

    default public Variable emitArrayCompareTo(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value lengthA, Value arrayB, Value lengthB) {
        throw GraalError.unimplemented("String.compareTo substitution is not implemented on this architecture");
    }

    default public Variable emitArrayRegionCompareTo(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length, Value dynamicStrides) {
        throw GraalError.unimplemented("String.compareTo substitution is not implemented on this architecture");
    }

    default public Variable emitArrayRegionCompareTo(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        throw GraalError.unimplemented("String.compareTo substitution is not implemented on this architecture");
    }

    default public Variable emitVectorizedMismatch(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value arrayB, Value length, Value stride) {
        throw GraalError.unimplemented("vectorizedMismatch substitution is not implemented on this architecture");
    }

    default public Variable emitVectorizedHashCode(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayStart, Value length, Value initialValue, JavaKind arrayKind) {
        throw GraalError.unimplemented("vectorizedHashCode substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEquals(JavaKind commonElementKind, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        throw GraalError.unimplemented("Array.equals substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEquals(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        throw GraalError.unimplemented("Array.equals with different types with offset substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEqualsDynamicStrides(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length, Value dynamicStrides) {
        throw GraalError.unimplemented("Array.equals with different types with offset substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEqualsWithMask(Stride strideA, Stride strideB, Stride strideMask, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value mask, Value length) {
        throw GraalError.unimplemented("Array.equals with different types with offset substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEqualsWithMaskDynamicStrides(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value mask, Value length, Value dynamicStrides) {
        throw GraalError.unimplemented("Array.equals with different types with offset substitution is not implemented on this architecture");
    }

    default public void emitArrayCopyWithConversion(Stride strideSrc, Stride strideDst, EnumSet<?> runtimeCheckedCPUFeatures, Value arraySrc, Value offsetSrc, Value arrayDst, Value offsetDst, Value length) {
        throw GraalError.unimplemented("Array.copy with variable stride substitution is not implemented on this architecture");
    }

    default public void emitArrayCopyWithConversion(EnumSet<?> runtimeCheckedCPUFeatures, Value arraySrc, Value offsetSrc, Value arrayDst, Value offsetDst, Value length, Value dynamicStrides) {
        throw GraalError.unimplemented("Array.copy with variable stride substitution is not implemented on this architecture");
    }

    default public Variable emitCalcStringAttributes(CalcStringAttributesEncoding encoding, EnumSet<?> runtimeCheckedCPUFeatures, Value array, Value offset, Value length, boolean assumeValid) {
        throw GraalError.unimplemented("CalcStringAttributes substitution is not implemented on this architecture");
    }

    default public Variable emitArrayIndexOf(Stride stride, ArrayIndexOfVariant variant, EnumSet<?> runtimeCheckedCPUFeatures, Value array, Value offset, Value length, Value fromIndex, Value ... searchValues) {
        throw GraalError.unimplemented("String.indexOf substitution is not implemented on this architecture");
    }

    default public void emitStringLatin1Inflate(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value len) {
        throw GraalError.unimplemented("StringLatin1.inflate substitution is not implemented on this architecture");
    }

    default public Variable emitStringUTF16Compress(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value len) {
        throw GraalError.unimplemented("StringUTF16.compress substitution is not implemented on this architecture");
    }

    default public Variable emitEncodeArray(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value length, CharsetName charset) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Variable emitCountPositives(EnumSet<?> runtimeCheckedCPUFeatures, Value array, Value length) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitAESEncrypt(Value from, Value to, Value key) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitAESDecrypt(Value from, Value to, Value key) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Variable emitCTRAESCrypt(Value inAddr, Value outAddr, Value kAddr, Value counterAddr, Value len, Value encryptedCounterAddr, Value usedPtr) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Variable emitCBCAESEncrypt(Value inAddr, Value outAddr, Value kAddr, Value rAddr, Value len) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Variable emitCBCAESDecrypt(Value inAddr, Value outAddr, Value kAddr, Value rAddr, Value len) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitGHASHProcessBlocks(Value state, Value hashSubkey, Value data, Value blocks) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitBigIntegerMultiplyToLen(Value x, Value xlen, Value y, Value ylen, Value z, Value zlen) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Variable emitBigIntegerMulAdd(Value out, Value in, Value offset, Value len, Value k) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitBigIntegerSquareToLen(Value x, Value len, Value z, Value zlen) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitSha1ImplCompress(Value buf, Value state) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitSha256ImplCompress(Value buf, Value state) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitSha3ImplCompress(Value buf, Value state, Value blockSize) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitSha512ImplCompress(Value buf, Value state) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public void emitMD5ImplCompress(Value buf, Value state) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    public void emitBlackhole(Value var1);

    public LIRKind getLIRKind(Stamp var1);

    public void emitPause();

    default public void emitSpinWait() {
    }

    public void emitPrefetchAllocate(Value var1);

    public Value emitCompress(Value var1, CompressEncoding var2, boolean var3);

    public Value emitUncompress(Value var1, CompressEncoding var2, boolean var3);

    default public void emitConvertNullToZero(AllocatableValue result, Value input) {
        if (LIRValueUtil.isJavaConstant(input)) {
            if (LIRValueUtil.asJavaConstant(input).isNull()) {
                this.emitMoveConstant(result, (Constant)JavaConstant.forPrimitiveInt((int)(input.getPlatformKind().getSizeInBytes() * 8), (long)0L));
            } else {
                this.emitMove(result, input);
            }
        } else {
            this.emitConvertNullToZero(result, (AllocatableValue)input);
        }
    }

    default public void emitConvertNullToZero(AllocatableValue result, AllocatableValue input) {
        this.emitMove(result, (Value)input);
    }

    default public void emitConvertZeroToNull(AllocatableValue result, Value input) {
        this.emitMove(result, input);
    }

    public void emitSpeculationFence();

    default public VirtualStackSlot allocateStackMemory(int sizeInBytes, int alignmentInBytes) {
        return this.getResult().getFrameMapBuilder().allocateStackMemory(sizeInBytes, alignmentInBytes);
    }

    default public Value emitTimeStamp() {
        throw new GraalError("Emitting code to return the current value of the timestamp counter is not currently supported on %s", this.target().arch);
    }

    default public void emitProcid(AllocatableValue dst) {
        throw new GraalError("Emitting code to return the current value of the procid is not currently supported on %s", this.target().arch);
    }

    default public Value emitReadCallerStackPointer(Stamp wordStamp) {
        return this.emitAddress((AllocatableValue)StackSlot.get((ValueKind)this.getLIRKind(wordStamp), (int)0, (boolean)true));
    }

    default public Value emitReadReturnAddress(Stamp wordStamp, int returnAddressSize) {
        return this.emitMove((Value)StackSlot.get((ValueKind)this.getLIRKind(wordStamp), (int)(-returnAddressSize), (boolean)true));
    }

    default public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        throw GraalError.unimplemented("Bulk zeroing is not implemented on this architecture");
    }

    public void emitCacheWriteback(Value var1);

    public void emitCacheWritebackSync(boolean var1);

    default public VectorSize getMaxVectorSize(EnumSet<?> runtimeCheckedCPUFeatures) {
        throw GraalError.unimplemented("Max vector size is not specified on this architecture");
    }

    public static enum CharsetName {
        ASCII,
        ISO_8859_1;

    }

    public static enum ArrayIndexOfVariant {
        MatchAny,
        MatchRange,
        WithMask,
        FindTwoConsecutive,
        FindTwoConsecutiveWithMask,
        Table;

    }

    public static enum CalcStringAttributesEncoding {
        LATIN1(Stride.S1),
        BMP(Stride.S2),
        UTF_8(Stride.S1),
        UTF_16(Stride.S2),
        UTF_32(Stride.S4);

        public final Stride stride;
        private static final int FLAG_MULTIBYTE = 8;
        public static final int CR_7BIT = 0;
        public static final int CR_8BIT = 1;
        public static final int CR_16BIT = 2;
        public static final int CR_VALID = 3;
        public static final int CR_BROKEN = 4;
        public static final int CR_VALID_MULTIBYTE = 11;
        public static final int CR_BROKEN_MULTIBYTE = 12;

        private CalcStringAttributesEncoding(Stride stride) {
            this.stride = stride;
        }
    }

    public static abstract class BlockScope
    implements AutoCloseable {
        public abstract BasicBlock<?> getCurrentBlock();

        @Override
        public abstract void close();
    }
}

