/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.phases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import jdk.graal.compiler.core.common.util.PhasePlan;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.TargetDescription;

public class LIRPhaseSuite<C>
extends LIRPhase<C>
implements PhasePlan<LIRPhase<C>> {
    private List<LIRPhase<C>> phases = new ArrayList<LIRPhase<C>>();
    public static final TimerKey LIRHintedGC = DebugContext.timer("LIRHintedGC").doc("Time spent in hinted GC performed before each LIR phase.");

    @Override
    public List<LIRPhase<C>> getPhases() {
        return Collections.unmodifiableList(this.phases);
    }

    public final void prependPhase(LIRPhase<C> phase) {
        this.phases.add(0, phase);
    }

    public final void appendPhase(LIRPhase<C> phase) {
        this.phases.add(phase);
    }

    public final ListIterator<LIRPhase<C>> findPhase(Class<? extends LIRPhase<C>> phaseClass) {
        ListIterator<LIRPhase<C>> it = this.phases.listIterator();
        if (LIRPhaseSuite.findNextPhase(it, phaseClass)) {
            return it;
        }
        return null;
    }

    public final <T extends LIRPhase<C>> T findPhaseInstance(Class<T> phaseClass) {
        ListIterator<LIRPhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            LIRPhase<C> phase = it.next();
            if (!phaseClass.isInstance(phase)) continue;
            return (T)((LIRPhase)phaseClass.cast(phase));
        }
        return null;
    }

    public static <C> boolean findNextPhase(ListIterator<LIRPhase<C>> it, Class<? extends LIRPhase<C>> phaseClass) {
        while (it.hasNext()) {
            LIRPhase<C> phase = it.next();
            if (!phaseClass.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final void run(TargetDescription target, LIRGenerationResult lirGenRes, C context) {
        for (LIRPhase<C> phase : this.phases) {
            try (DebugCloseable timer = LIRHintedGC.start(lirGenRes.getLIR().getDebug());){
                GraalServices.notifyLowMemoryPoint(false);
            }
            phase.apply(target, lirGenRes, context);
        }
    }

    public LIRPhaseSuite<C> copy() {
        LIRPhaseSuite<C> suite = new LIRPhaseSuite<C>();
        suite.phases.addAll(this.phases);
        return suite;
    }

    public String toString() {
        return String.format("%s:%n%s", this.getClass().getSimpleName(), new PhasePlan.Printer().toString(this));
    }
}

