/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.ssa;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.ssa.SSAVerifier;
import jdk.vm.ci.meta.Value;

public final class SSAUtil {
    public static void forEachPhiValuePair(LIR lir, BasicBlock<?> merge, BasicBlock<?> pred, PhiValueVisitor visitor) {
        if (merge.getPredecessorCount() < 2) {
            return;
        }
        if (Assertions.assertionsEnabled()) {
            boolean found = false;
            for (int i = 0; i < merge.getPredecessorCount(); ++i) {
                found = found || merge.getPredecessorAt(i) == pred;
            }
            assert (found) : String.format("%s not in predecessor list", pred);
        }
        assert (pred.getSuccessorCount() == 1) : String.format("Merge predecessor block %s has more than one successor", pred);
        assert (pred.getSuccessorAt(0) == merge) : String.format("Predecessor block %s has wrong successor: %s, should be: %s", pred, pred.getSuccessorAt(0), merge);
        StandardOp.JumpOp jump = SSAUtil.phiOut(lir, pred);
        StandardOp.LabelOp label = SSAUtil.phiIn(lir, merge);
        assert (label.getPhiSize() == jump.getPhiSize()) : String.format("Phi In/Out size mismatch: in=%d vs. out=%d", label.getPhiSize(), jump.getPhiSize());
        for (int i = 0; i < label.getPhiSize(); ++i) {
            visitor.visit(label.getIncomingValue(i), jump.getOutgoingValue(i));
        }
    }

    public static StandardOp.JumpOp phiOut(LIR lir, BasicBlock<?> block) {
        assert (block.getSuccessorCount() == 1) : Assertions.errorMessage(block);
        ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
        int index = instructions.size() - 1;
        LIRInstruction op = instructions.get(index);
        return (StandardOp.JumpOp)op;
    }

    public static int phiOutIndex(LIR lir, BasicBlock<?> block) {
        assert (block.getSuccessorCount() == 1) : Assertions.errorMessage(block);
        ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
        int index = instructions.size() - 1;
        assert (instructions.get(index) instanceof StandardOp.JumpOp) : instructions.get(index);
        return index;
    }

    public static StandardOp.LabelOp phiIn(LIR lir, BasicBlock<?> block) {
        assert (block.getPredecessorCount() > 1) : Assertions.errorMessageContext("block", block);
        StandardOp.LabelOp label = (StandardOp.LabelOp)lir.getLIRforBlock(block).get(0);
        return label;
    }

    public static void removePhiOut(LIR lir, BasicBlock<?> block) {
        StandardOp.JumpOp jump = SSAUtil.phiOut(lir, block);
        jump.clearOutgoingValues();
    }

    public static void removePhiIn(LIR lir, BasicBlock<?> block) {
        StandardOp.LabelOp label = SSAUtil.phiIn(lir, block);
        label.clearIncomingValues();
    }

    public static boolean verifySSAForm(LIR lir) {
        return new SSAVerifier(lir).verify();
    }

    public static void verifyPhi(LIR lir, BasicBlock<?> merge) {
        assert (merge.getPredecessorCount() > 1) : Assertions.errorMessageContext("merge", merge);
        for (int i = 0; i < merge.getPredecessorCount(); ++i) {
            Object pred = merge.getPredecessorAt(i);
            SSAUtil.forEachPhiValuePair(lir, merge, pred, (phiIn, phiOut) -> {
                assert (phiIn.getValueKind().equals(phiOut.getValueKind()) || phiIn.getPlatformKind().equals((Object)phiOut.getPlatformKind()) && LIRKind.isUnknownReference(phiIn) && LIRKind.isValue(phiOut)) : Assertions.errorMessageContext("phiIn", phiIn, "phiOut", phiOut);
            });
        }
    }

    public static int indexOfValue(StandardOp.LabelOp label, Value value) {
        for (int i = 0; i < label.getIncomingSize(); ++i) {
            if (!label.getIncomingValue(i).equals((Object)value)) continue;
            return i;
        }
        return -1;
    }

    public static interface PhiValueVisitor {
        public void visit(Value var1, Value var2);
    }
}

