/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.ssa;

import java.util.EnumSet;
import java.util.HashMap;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BasicBlockSet;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

final class SSAVerifier {
    private final LIR lir;
    private final BasicBlockSet visited;
    private final HashMap<Value, Entry> defined;
    private BasicBlock<?> currentBlock;

    SSAVerifier(LIR lir) {
        this.lir = lir;
        this.visited = lir.getControlFlowGraph().createBasicBlockSet();
        this.defined = new HashMap();
    }

    public boolean verify() {
        DebugContext debug = this.lir.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"SSAVerifier", this.lir);){
            for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
                this.doBlock(block);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return true;
    }

    private void doBlock(BasicBlock<?> b) {
        if (this.visited.get(b)) {
            return;
        }
        for (int i = 0; i < b.getPredecessorCount(); ++i) {
            Object pred = b.getPredecessorAt(i);
            if (b.isLoopHeader() && ((BasicBlock)pred).isLoopEnd()) continue;
            this.doBlock((BasicBlock<?>)pred);
        }
        try (Indent indent = this.lir.getDebug().logAndIndent(2, "handle block %s", b);){
            assert (this.verifyBlock(b));
        }
    }

    private boolean verifyBlock(BasicBlock<?> block) {
        this.currentBlock = block;
        assert (!this.visited.get(block)) : "Block already visited: " + String.valueOf(block);
        this.visited.set(block);
        for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
            op.visitEachAlive(this::useConsumer);
            op.visitEachState(this::useConsumer);
            op.visitEachInput(this::useConsumer);
            op.visitEachTemp(this::defConsumer);
            op.visitEachOutput(this::defConsumer);
        }
        this.currentBlock = null;
        return true;
    }

    private void useConsumer(LIRInstruction inst, Value val, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        Value value = LIRValueUtil.stripCast(val);
        if (SSAVerifier.shouldProcess(value)) assert (this.defined.containsKey(value) || flags.contains((Object)LIRInstruction.OperandFlag.UNINITIALIZED)) : String.format("Value %s used at instruction %s in block %s but never defined", value, inst, this.currentBlock);
    }

    private void defConsumer(LIRInstruction inst, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        assert (!LIRValueUtil.isCast(value));
        if (SSAVerifier.shouldProcess(value)) {
            assert (!this.defined.containsKey(value)) : String.format("Value %s redefined at %s (previous definition %s in block %s)", value, inst, this.defined.get((Object)value).inst, this.defined.get((Object)value).block);
            this.defined.put(value, new Entry(inst, this.currentBlock));
        }
    }

    private static boolean shouldProcess(Value value) {
        return !value.equals((Object)Value.ILLEGAL) && !LIRValueUtil.isConstantValue(value) && !ValueUtil.isRegister((Value)value) && !LIRValueUtil.isStackSlotValue(value);
    }

    private static class Entry {
        private final LIRInstruction inst;
        private final BasicBlock<?> block;

        Entry(LIRInstruction inst, BasicBlock<?> block) {
            this.inst = inst;
            this.block = block;
        }
    }
}

