/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.util;

import java.util.EnumSet;
import java.util.Objects;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.InstructionValueConsumer;
import jdk.graal.compiler.lir.InstructionValueProcedure;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class IndexedValueMap {
    private static final int MAP_FALLBACK_THRESHOLD = 128;
    private Value[] values;
    private EconomicMap<Integer, Value> fallbackMap;
    private boolean copyOnWrite;

    public IndexedValueMap() {
        this.values = Value.NO_VALUES;
    }

    public IndexedValueMap(IndexedValueMap other) {
        this.values = other.values;
        this.fallbackMap = other.fallbackMap;
        this.copyOnWrite = true;
        other.copyOnWrite = true;
    }

    public Value get(int index) {
        if (this.values != null) {
            if (index < this.values.length) {
                return this.values[index];
            }
        } else if (this.fallbackMap != null) {
            return (Value)this.fallbackMap.get((Object)index);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void put(int index, Value value) {
        if (this.values != null) {
            if (this.values.length <= index) {
                if (value == null) {
                    return;
                }
                if (index + 1 > 128) {
                    this.fallbackToMap();
                    this.put(index, value);
                    return;
                }
                Value[] newValues = new Value[index + 1];
                if (this.values.length > 0) {
                    System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                }
                this.values = newValues;
                this.copyOnWrite = false;
            } else if (this.copyOnWrite) {
                if (Objects.equals(this.values[index], value)) {
                    return;
                }
                this.doCopyOnWrite(value == null ? 0 : index + 1);
            }
            if (index >= this.values.length) return;
            this.values[index] = value;
            return;
        }
        if (this.fallbackMap == null) {
            if (value == null) {
                return;
            }
            this.fallbackMap = EconomicMap.create();
            this.copyOnWrite = false;
        } else if (this.copyOnWrite) {
            if (Objects.equals(this.fallbackMap.get((Object)index), value)) {
                return;
            }
            this.doCopyMapOnWrite(value == null);
        }
        if (this.fallbackMap == null) return;
        this.fallbackMap.put((Object)index, (Object)value);
    }

    private void doCopyOnWrite(int minLimit) {
        int limit;
        for (limit = this.values.length; limit > minLimit && this.values[limit - 1] == null; --limit) {
        }
        if (limit == 0) {
            this.values = Value.NO_VALUES;
        } else {
            Value[] newValues = new Value[limit];
            System.arraycopy(this.values, 0, newValues, 0, limit);
            this.values = newValues;
        }
        this.copyOnWrite = false;
    }

    private void doCopyMapOnWrite(boolean allowNullFallbackMap) {
        EconomicMap newFallbackMap = allowNullFallbackMap ? null : EconomicMap.create();
        MapCursor valueEntry = this.fallbackMap.getEntries();
        while (valueEntry.advance()) {
            if (valueEntry.getValue() == null) continue;
            if (newFallbackMap == null) {
                newFallbackMap = EconomicMap.create();
            }
            newFallbackMap.put((Object)((Integer)valueEntry.getKey()), (Object)((Value)valueEntry.getValue()));
        }
        this.fallbackMap = newFallbackMap;
        this.copyOnWrite = false;
    }

    private boolean isEmpty() {
        boolean empty;
        block2: {
            block3: {
                empty = true;
                if (this.values == null) break block3;
                for (Value value : this.values) {
                    if (value == null) continue;
                    empty = false;
                    break block2;
                }
                break block2;
            }
            if (this.fallbackMap == null) break block2;
            MapCursor valueEntry = this.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                if (valueEntry.getValue() == null) continue;
                empty = false;
                break;
            }
        }
        return empty;
    }

    private void fallbackToMap() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (this.fallbackMap == null) {
                this.fallbackMap = EconomicMap.create();
            }
            this.fallbackMap.put((Object)i, (Object)this.values[i]);
        }
        this.values = null;
        this.copyOnWrite = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putAll(IndexedValueMap stack) {
        Value[] otherValues;
        block17: {
            int limit;
            block19: {
                block18: {
                    if (stack.isEmpty()) {
                        return;
                    }
                    if (this.isEmpty()) {
                        this.values = stack.values;
                        this.fallbackMap = stack.fallbackMap;
                        this.copyOnWrite = true;
                        stack.copyOnWrite = true;
                        return;
                    }
                    otherValues = stack.values;
                    if (this.values == null || otherValues == null) break block17;
                    limit = otherValues.length;
                    if (limit <= this.values.length) break block18;
                    while (limit > 0 && otherValues[limit - 1] == null) {
                        --limit;
                    }
                    if (limit > this.values.length) {
                        if (limit > 128) {
                            this.fallbackToMap();
                            this.putAll(stack);
                            return;
                        }
                        Value[] newValues = new Value[limit];
                        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                        this.values = newValues;
                        this.copyOnWrite = false;
                        break block19;
                    } else if (this.copyOnWrite) {
                        this.doCopyOnWrite(limit);
                    }
                    break block19;
                }
                if (this.copyOnWrite) {
                    this.doCopyOnWrite(limit);
                }
            }
            for (int i = 0; i < limit; ++i) {
                Value value = otherValues[i];
                if (value == null) continue;
                this.values[i] = IndexedValueMap.mergeValues(value, this.values[i]);
            }
            return;
        }
        if (this.values != null || otherValues == null) {
            if (this.values != null) {
                this.fallbackToMap();
            } else if (this.copyOnWrite) {
                this.doCopyMapOnWrite(false);
            }
            MapCursor valueEntry = stack.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                Value value = (Value)valueEntry.getValue();
                if (value == null) continue;
                this.fallbackMap.put((Object)((Integer)valueEntry.getKey()), (Object)IndexedValueMap.mergeValues(value, (Value)this.fallbackMap.get((Object)((Integer)valueEntry.getKey()))));
            }
            return;
        } else {
            if (this.copyOnWrite) {
                this.doCopyMapOnWrite(false);
            }
            for (int i = 0; i < otherValues.length; ++i) {
                Value value = otherValues[i];
                if (value == null) continue;
                this.fallbackMap.put((Object)i, (Object)IndexedValueMap.mergeValues(value, (Value)this.fallbackMap.get((Object)i)));
            }
        }
    }

    private static Value mergeValues(Value v1, Value v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1.equals((Object)v2)) {
            return v1;
        }
        throw GraalError.shouldNotReachHere("unable to merge %s and %s".formatted(v1, v2));
    }

    public boolean equals(Object other) {
        if (other instanceof IndexedValueMap) {
            IndexedValueMap that = (IndexedValueMap)other;
            return this.isSubsetOf(that) && that.isSubsetOf(this);
        }
        return false;
    }

    private boolean isSubsetOf(IndexedValueMap other) {
        boolean isSubset;
        block2: {
            block3: {
                isSubset = true;
                if (this.values == null) break block3;
                for (int i = 0; i < this.values.length; ++i) {
                    if (Objects.equals(this.values[i], other.get(i))) continue;
                    isSubset = false;
                    break block2;
                }
                break block2;
            }
            if (this.fallbackMap == null) break block2;
            MapCursor valueEntry = this.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                if (Objects.equals(valueEntry.getValue(), other.get((Integer)valueEntry.getKey()))) continue;
                isSubset = false;
                break;
            }
        }
        return isSubset;
    }

    public void forEach(LIRInstruction inst, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, InstructionValueProcedure proc) {
        block3: {
            block2: {
                if (this.values == null) break block2;
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.values[i] = proc.doValue(inst, this.values[i], mode, flags);
                }
                break block3;
            }
            if (this.fallbackMap == null) break block3;
            MapCursor valueEntry = this.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                if (valueEntry.getValue() == null) continue;
                valueEntry.setValue((Object)proc.doValue(inst, (Value)valueEntry.getValue(), mode, flags));
            }
        }
    }

    public void visitEach(LIRInstruction inst, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, InstructionValueConsumer consumer) {
        block3: {
            block2: {
                if (this.values == null) break block2;
                for (Value v : this.values) {
                    if (v == null) continue;
                    consumer.visitValue(inst, v, mode, flags);
                }
                break block3;
            }
            if (this.fallbackMap == null) break block3;
            MapCursor valueEntry = this.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                Value v = (Value)valueEntry.getValue();
                if (v == null) continue;
                consumer.visitValue(inst, v, mode, flags);
            }
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean comma = false;
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(i);
                sb.append(": ");
                sb.append(this.values[i]);
            }
        } else if (this.fallbackMap != null) {
            MapCursor valueEntry = this.fallbackMap.getEntries();
            while (valueEntry.advance()) {
                if (valueEntry.getValue() == null) continue;
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(valueEntry.getKey());
                sb.append(": ");
                sb.append(valueEntry.getValue());
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

