/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Optional;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.loop.phases.LoopPhase;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;

public class LoopPeelingPhase
extends LoopPhase<LoopPolicies> {
    public LoopPeelingPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    public static boolean canPeel(LoopEx loop) {
        return LoopPeelingPhase.stateAllowsPeeling(loop.loopBegin().graph().getGraphState()) && loop.canDuplicateLoop() && loop.loopBegin().getLoopEndCount() > 0;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState));
    }

    private static boolean stateAllowsPeeling(GraphState graphState) {
        return graphState.isBeforeStage(GraphState.StageFlag.FSA) && graphState.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            boolean shouldPeelAlot = LoopPolicies.Options.PeelALot.getValue(graph.getOptions());
            int shouldPeelOnly = LoopPolicies.Options.PeelOnlyLoopWithNodeID.getValue(graph.getOptions());
            try (DebugContext.Scope s = debug.scope((Object)"peeling", data.getCFG());){
                for (LoopEx loop : data.outerFirst()) {
                    if (!LoopPeelingPhase.canPeel(loop)) continue;
                    for (int iteration = 0; iteration < Options.IterativePeelingLimit.getValue(graph.getOptions()); ++iteration) {
                        if (!shouldPeelAlot && !this.getPolicies().shouldPeel(loop, data.getCFG(), context, iteration) || shouldPeelOnly != -1 && shouldPeelOnly != loop.loopBegin().getId()) continue;
                        LoopTransformations.peel(loop);
                        loop.invalidateFragmentsAndIVs();
                        data.getCFG().updateCachedLocalLoopFrequency(loop.loopBegin(), f -> f.decrementFrequency(1.0));
                        debug.dump(3, (Object)graph, "After peeling loop %s", loop);
                    }
                }
                data.deleteUnusedNodes();
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }

    public static class Options {
        public static final OptionKey<Integer> IterativePeelingLimit = new OptionKey<Integer>(2);
    }
}

