/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Optional;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class LoopSafepointEliminationPhase
extends BasePhase<MidTierContext> {
    private static final long IntegerRangeDistance = Math.abs(0xFFFFFFFFL);

    protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
        return true;
    }

    protected void onSafepointDisabledLoopBegin(LoopEx loop) {
    }

    protected boolean allowGuestSafepoints() {
        return false;
    }

    public static boolean loopIsIn32BitRange(LoopEx loop) {
        if (loop.counted().getStamp().getBits() <= 32) {
            return true;
        }
        Stamp limitStamp = loop.counted().getTripCountLimit().stamp(NodeView.DEFAULT);
        if (limitStamp instanceof IntegerStamp) {
            IntegerStamp limitIStamp = (IntegerStamp)limitStamp;
            long upperBoundLimit = limitIStamp.upperBound();
            Stamp startStamp = loop.counted().getBodyIVStart().stamp(NodeView.DEFAULT);
            if (startStamp instanceof IntegerStamp) {
                IntegerStamp startIStamp = (IntegerStamp)startStamp;
                long lowerBoundStart = startIStamp.lowerBound();
                if (IntegerStamp.subtractionOverflows(upperBoundLimit, lowerBoundStart, 64)) {
                    return false;
                }
                long startToLimitDistance = Math.abs(upperBoundLimit - lowerBoundStart);
                InductionVariable counter = loop.counted().getLimitCheckedIV();
                long stride = counter.isConstantStride() ? Math.abs(counter.constantStride()) : 1L;
                long strideRelativeStartToLimitDistance = startToLimitDistance / stride;
                return strideRelativeStartToLimitDistance <= IntegerRangeDistance;
            }
        }
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected final void run(StructuredGraph graph, MidTierContext context) {
        LoopsData loops = context.getLoopsDataProvider().getLoopsData(graph);
        if (Options.RemoveLoopSafepoints.getValue(graph.getOptions()).booleanValue()) {
            loops.detectCountedLoops();
            for (LoopEx loop : loops.countedLoops()) {
                if (!loop.loop().getChildren().isEmpty() || !loop.loopBegin().isPreLoop() && !loop.loopBegin().isPostLoop() && !LoopSafepointEliminationPhase.loopIsIn32BitRange(loop) && !loop.loopBegin().isStripMinedInner()) continue;
                boolean hasSafepoint = false;
                for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                    hasSafepoint |= loopEnd.canSafepoint();
                }
                if (!hasSafepoint) continue;
                if (!loop.counted().counterNeverOverflows()) {
                    boolean allowsLoopLimitChecks = context.getOptimisticOptimizations().useLoopLimitChecks(graph.getOptions());
                    boolean allowsFloatingGuards = graph.getGuardsStage().allowsFloatingGuards();
                    if (!allowsLoopLimitChecks || !allowsFloatingGuards) continue;
                    loop.counted().createOverFlowGuard();
                }
                loop.loopBegin().disableSafepoint();
                if (loop.loopBegin().isStripMinedInner()) {
                    loop.loopBegin().disableGuestSafepoint();
                } else {
                    this.onSafepointDisabledLoopBegin(loop);
                }
                graph.getOptimizationLog().report(LoopSafepointEliminationPhase.class, "SafepointElimination", loop.loopBegin());
            }
        }
        for (LoopEx loop : loops.loops()) {
            if (!this.allowGuestSafepoints()) {
                loop.loopBegin().disableGuestSafepoint();
            }
            block3: for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                for (HIRBlock b = loops.getCFG().blockFor(loopEnd); b != loop.loop().getHeader(); b = (HIRBlock)b.getDominator()) {
                    assert (b != null);
                    for (FixedNode node : b.getNodes()) {
                        boolean canDisableSafepoint = LoopSafepointEliminationPhase.canDisableSafepoint(node, context);
                        boolean disabledInSubclass = this.onCallInLoop(loopEnd, node);
                        if (!canDisableSafepoint) continue;
                        loopEnd.disableSafepoint();
                        graph.getOptimizationLog().report(LoopSafepointEliminationPhase.class, "SafepointElimination", loop.loopBegin());
                        if (!disabledInSubclass) continue;
                        continue block3;
                    }
                }
            }
        }
        loops.deleteUnusedNodes();
    }

    public static boolean canDisableSafepoint(FixedNode node, CoreProviders context) {
        if (node instanceof Invoke) {
            Invoke invoke = (Invoke)((Object)node);
            ResolvedJavaMethod method = invoke.getTargetMethod();
            return context.getMetaAccessExtensionProvider().isGuaranteedSafepoint(method, invoke.getInvokeKind().isDirect());
        }
        if (node instanceof ForeignCall) {
            return ((ForeignCall)((Object)node)).isGuaranteedSafepoint();
        }
        return false;
    }

    public static class Options {
        public static final OptionKey<Boolean> RemoveLoopSafepoints = new OptionKey<Boolean>(true);
    }
}

