/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.loop.phases.LoopPhase;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.collections.EconomicMap;

public class LoopUnswitchingPhase
extends LoopPhase<LoopPolicies> {
    private static final CounterKey UNSWITCH_CANDIDATES = DebugContext.counter("UnswitchCandidates");
    private static final CounterKey UNSWITCH_EARLY_REJECTS = DebugContext.counter("UnswitchEarlyRejects");

    public LoopUnswitchingPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            boolean unswitched;
            block0: do {
                unswitched = false;
                LoopsData dataUnswitch = context.getLoopsDataProvider().getLoopsData(graph);
                for (LoopEx loop : dataUnswitch.outerFirst()) {
                    if (!LoopUnswitchingPhase.canUnswitch(loop)) continue;
                    if (this.getPolicies().shouldTryUnswitch(loop)) {
                        EconomicMap<ValueNode, List<ControlSplitNode>> controlSplits = LoopTransformations.findUnswitchable(loop);
                        UNSWITCH_CANDIDATES.increment(debug);
                        LoopPolicies.UnswitchingDecision decision = this.getPolicies().shouldUnswitch(loop, controlSplits);
                        if (!decision.shouldUnswitch()) continue;
                        List<ControlSplitNode> splits = decision.getControlSplits();
                        if (debug.isLogEnabled()) {
                            LoopUnswitchingPhase.logUnswitch(loop, splits);
                        }
                        LoopTransformations.unswitch(loop, splits, decision.isTrivial());
                        unswitched = true;
                        continue block0;
                    }
                    UNSWITCH_EARLY_REJECTS.increment(debug);
                }
            } while (unswitched);
        }
    }

    private static boolean canUnswitch(LoopEx loop) {
        return loop.canDuplicateLoop();
    }

    private static void logUnswitch(LoopEx loop, List<ControlSplitNode> controlSplits) {
        StringBuilder sb = new StringBuilder("Unswitching ");
        sb.append(loop).append(" at ");
        for (ControlSplitNode controlSplit : controlSplits) {
            sb.append(controlSplit).append(" [");
            Iterator it = controlSplit.successors().iterator();
            while (it.hasNext()) {
                sb.append(controlSplit.probability((AbstractBeginNode)it.next()));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        loop.entryPoint().getDebug().log("%s", sb);
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }
}

