/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.EnumSet;
import java.util.Optional;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.GuardedValueNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.MultiGuardNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.FloatingGuardPhase;
import jdk.graal.compiler.phases.Speculative;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public class SpeculativeGuardMovementPhase
extends PostRunCanonicalizationPhase<MidTierContext>
implements FloatingGuardPhase,
Speculative {
    private final boolean ignoreFrequency;
    private final boolean requireSpeculationLog;
    private static final int MAX_ITERATIONS = 3;
    private static final SpeculationReasonGroup GUARD_MOVEMENT_LOOP_SPECULATIONS = new SpeculationReasonGroup("GuardMovement", ResolvedJavaMethod.class, Integer.TYPE, DeoptimizationReason.class);

    public SpeculativeGuardMovementPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
        this.ignoreFrequency = false;
        this.requireSpeculationLog = true;
    }

    public SpeculativeGuardMovementPhase(CanonicalizerPhase canonicalizer, boolean ignoreFrequency, boolean requireSpeculationLog) {
        super(canonicalizer);
        this.ignoreFrequency = ignoreFrequency;
        this.requireSpeculationLog = requireSpeculationLog;
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.GUARD_MOVEMENT, graphState), BasePhase.NotApplicable.when(!graphState.getGuardsStage().allowsFloatingGuards(), "Floating guards must be allowed"));
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        EconomicSetNodeEventListener change = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.INPUT_CHANGED));
        for (int i = 0; i < 3; ++i) {
            boolean iterate = false;
            try (Graph.NodeEventScope news = graph.trackNodeEvents(change);){
                if (graph.getDebug().isCountEnabled()) {
                    DebugContext.counter("SpeculativeGuardMovement_Iteration" + i).increment(graph.getDebug());
                }
                LoopsData loops = context.getLoopsDataProvider().getLoopsData(graph);
                loops.detectCountedLoops();
                iterate = SpeculativeGuardMovementPhase.performSpeculativeGuardMovement(context, graph, loops, this.ignoreFrequency, this.requireSpeculationLog);
            }
            if (change.getNodes().isEmpty() || !iterate) break;
            change.getNodes().clear();
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.GUARD_MOVEMENT);
    }

    public static boolean performSpeculativeGuardMovement(MidTierContext context, StructuredGraph graph, LoopsData loops) {
        return SpeculativeGuardMovementPhase.performSpeculativeGuardMovement(context, graph, loops, null, false, true);
    }

    public static boolean performSpeculativeGuardMovement(MidTierContext context, StructuredGraph graph, LoopsData loops, boolean ignoreFrequency, boolean requireSpeculationLog) {
        return SpeculativeGuardMovementPhase.performSpeculativeGuardMovement(context, graph, loops, null, ignoreFrequency, requireSpeculationLog);
    }

    public static boolean performSpeculativeGuardMovement(MidTierContext context, StructuredGraph graph, LoopsData loops, NodeBitMap toProcess) {
        return SpeculativeGuardMovementPhase.performSpeculativeGuardMovement(context, graph, loops, toProcess, false, true);
    }

    public static boolean performSpeculativeGuardMovement(MidTierContext context, StructuredGraph graph, LoopsData loops, NodeBitMap toProcess, boolean ignoreFrequency, boolean requireSpeculationLog) {
        SpeculativeGuardMovement spec = new SpeculativeGuardMovement(loops, graph.createNodeMap(), graph, context.getProfilingInfo(), graph.getSpeculationLog(), toProcess, ignoreFrequency, requireSpeculationLog);
        spec.run();
        return spec.iterate;
    }

    private static SpeculationLog.SpeculationReason createSpeculation(DeoptimizationReason reason, LoopBeginNode loopBeginNode) {
        FrameState loopState = loopBeginNode.stateAfter();
        ResolvedJavaMethod method = null;
        int bci = 0;
        if (loopState != null) {
            method = loopState.getMethod();
            bci = loopState.bci;
        }
        return GUARD_MOVEMENT_LOOP_SPECULATIONS.createSpeculationReason(method, bci, reason);
    }

    private static boolean isInverted(LoopEx loop) {
        return loop.isCounted() && loop.counted().isInverted();
    }

    private static class SpeculativeGuardMovement
    implements Runnable {
        private final boolean ignoreFrequency;
        private final LoopsData loops;
        private final NodeMap<HIRBlock> earliestCache;
        private final StructuredGraph graph;
        private final ProfilingInfo profilingInfo;
        private final SpeculationLog speculationLog;
        boolean iterate;
        private final NodeBitMap toProcess;

        SpeculativeGuardMovement(LoopsData loops, NodeMap<HIRBlock> earliestCache, StructuredGraph graph, ProfilingInfo profilingInfo, SpeculationLog speculationLog, NodeBitMap toProcess, boolean ignoreFrequency, boolean requireSpeculationLog) {
            this.loops = loops;
            this.earliestCache = earliestCache;
            this.graph = graph;
            this.profilingInfo = profilingInfo;
            GraalError.guarantee(requireSpeculationLog ? speculationLog != null : true, "Graph has no speculation log attached: %s", (Object)graph);
            this.speculationLog = speculationLog;
            this.toProcess = toProcess;
            this.ignoreFrequency = ignoreFrequency;
        }

        @Override
        public void run() {
            for (GuardNode guard : this.graph.getNodes(GuardNode.TYPE)) {
                if (this.toProcess != null && (this.toProcess.isNew(guard) || !this.toProcess.contains(guard))) continue;
                HIRBlock anchorBlock = this.loops.getCFG().blockFor(guard.getAnchor().asNode());
                if (SpeculativeGuardMovement.exitsLoop(anchorBlock, this.earliestBlock(guard))) {
                    this.iterate = true;
                }
                this.graph.getDebug().dump(5, (Object)this.graph, "After processing guard %s", guard);
            }
        }

        private static boolean exitsLoop(HIRBlock earliestOld, HIRBlock earliestNew) {
            if (earliestOld == null) {
                return false;
            }
            return earliestOld.getLoopDepth() > earliestNew.getLoopDepth();
        }

        private HIRBlock earliestBlock(Node node) {
            ControlFlowGraph cfg = this.loops.getCFG();
            HIRBlock earliest = this.earliestCache.getAndGrow(node);
            if (earliest != null) {
                return earliest;
            }
            HIRBlock hIRBlock = earliest = cfg.getNodeToBlock().isNew(node) ? null : cfg.getNodeToBlock().get(node);
            if (earliest == null) {
                if (node instanceof IntegerDivRemNode) {
                    earliest = this.earliestBlock(node.predecessor());
                } else if (node instanceof PhiNode) {
                    PhiNode phi = (PhiNode)node;
                    earliest = this.earliestBlock(phi.merge());
                }
            }
            if (earliest != null) {
                this.earliestCache.setAndGrow(node, earliest);
                return earliest;
            }
            if (node instanceof GuardNode) {
                GuardNode guard = (GuardNode)node;
                LogicNode condition = guard.getCondition();
                Loop<HIRBlock> forcedHoisting = null;
                if (condition instanceof IntegerLessThanNode || condition instanceof IntegerBelowNode) {
                    forcedHoisting = this.tryOptimizeCompare(guard, (CompareNode)condition);
                } else if (condition instanceof InstanceOfNode) {
                    forcedHoisting = this.tryOptimizeInstanceOf(guard, (InstanceOfNode)condition);
                }
                earliest = this.earliestBlockForGuard(guard, forcedHoisting);
            } else {
                earliest = this.computeEarliestBlock(node);
            }
            this.earliestCache.setAndGrow(node, earliest);
            return earliest;
        }

        private HIRBlock computeEarliestBlock(Node node) {
            ControlFlowGraph cfg = this.loops.getCFG();
            assert (node.predecessor() == null);
            HIRBlock earliest = null;
            for (Node input : node.inputs().snapshot()) {
                if (input == null) continue;
                assert (input instanceof ValueNode) : Assertions.errorMessage(input);
                HIRBlock inputEarliest = input instanceof WithExceptionNode ? cfg.getNodeToBlock().get(((WithExceptionNode)input).next()) : this.earliestBlock(input);
                earliest = earliest == null || earliest.strictlyDominates(inputEarliest) ? inputEarliest : earliest;
            }
            if (earliest == null) {
                earliest = cfg.getStartBlock();
            }
            return earliest;
        }

        private Loop<HIRBlock> tryOptimizeCompare(GuardNode guard, CompareNode compare) {
            boolean mirrored;
            ValueNode bound;
            InductionVariable otherIV;
            InductionVariable iv;
            assert (compare instanceof IntegerLessThanNode || compare instanceof IntegerBelowNode) : Assertions.errorMessage(compare);
            assert (!compare.usages().filter(GuardNode.class).isEmpty()) : Assertions.errorMessage(compare, compare.usages());
            InductionVariable ivX = this.loops.getInductionVariable(compare.getX());
            InductionVariable ivY = this.loops.getInductionVariable(compare.getY());
            if (ivX == null && ivY == null) {
                return null;
            }
            if (ivX == null || ivY != null && ivY.getLoop().loop().getDepth() > ivX.getLoop().loop().getDepth()) {
                iv = ivY;
                otherIV = ivX;
                bound = compare.getX();
                mirrored = true;
            } else {
                iv = ivX;
                otherIV = ivY;
                bound = compare.getY();
                mirrored = false;
            }
            if (this.tryOptimizeCompare(compare, iv, bound, mirrored, guard)) {
                return iv.getLoop().loop();
            }
            if (otherIV != null && this.tryOptimizeCompare(compare, otherIV, iv.valueNode(), !mirrored, guard)) {
                return otherIV.getLoop().loop();
            }
            return null;
        }

        private boolean tryOptimizeCompare(CompareNode compare, InductionVariable iv, ValueNode bound, boolean mirrored, GuardNode guard) {
            OptimizedCompareTests tests = this.shouldOptimizeCompare(compare, iv, bound, guard, mirrored);
            if (tests != null) {
                this.optimizeCompare(compare, iv, guard, tests);
                return true;
            }
            return false;
        }

        private void optimizeCompare(CompareNode compare, InductionVariable iv, GuardNode guard, OptimizedCompareTests tests) {
            CountedLoopInfo countedLoop = iv.getLoop().counted();
            try (DebugCloseable position = compare.withNodeSourcePosition();){
                LogicNode newCompare = ShortCircuitOrNode.and(tests.extremumTest, guard.isNegated(), tests.initTest, guard.isNegated(), ProfileData.BranchProbabilityData.unknown());
                if (guard.isNegated()) {
                    guard.negate();
                }
                boolean createLoopEnteredCheck = true;
                if (SpeculativeGuardMovementPhase.isInverted(iv.getLoop())) {
                    createLoopEnteredCheck = false;
                }
                if (createLoopEnteredCheck) {
                    newCompare = this.createLoopEnterCheck(countedLoop, newCompare);
                }
                guard.replaceFirstInput(compare, newCompare);
                GuardingNode loopBodyGuard = MultiGuardNode.combine(guard, countedLoop.getBody());
                for (ValueNode usage : guard.usages().filter(ValueNode.class).snapshot()) {
                    if (usage == loopBodyGuard) continue;
                    usage.replaceFirstInput(guard, loopBodyGuard.asNode());
                }
            }
            this.graph.getOptimizationLog().report(SpeculativeGuardMovementPhase.class, "CompareOptimization", compare);
        }

        private OptimizedCompareTests computeNewCompareGuards(CompareNode compare, InductionVariable iv, ValueNode bound, boolean mirrored, GuardingNode overflowGuard) {
            return this.computeNewCompareGuards(compare, iv, bound, mirrored, overflowGuard, null);
        }

        private OptimizedCompareTests computeNewCompareGuards(CompareNode compare, InductionVariable iv, ValueNode bound, boolean mirrored, GuardingNode overflowGuard, ValueNode maxTripCountNode) {
            LogicNode initTest;
            LogicNode extremumTest;
            boolean zeroExtendBound = compare.condition().isUnsigned();
            ValueNode longBound = IntegerConvertNode.convert(bound, StampFactory.forKind(JavaKind.Long), zeroExtendBound, this.graph, NodeView.DEFAULT);
            ValueNode extremum = maxTripCountNode == null ? iv.extremumNode(true, StampFactory.forKind(JavaKind.Long)) : iv.extremumNode(true, StampFactory.forKind(JavaKind.Long), maxTripCountNode);
            ValueNode guardedExtremum = this.graph.addOrUniqueWithInputs(GuardedValueNode.create(extremum, overflowGuard));
            ValueNode y1 = longBound;
            ValueNode y2 = bound;
            ValueNode x1 = guardedExtremum;
            ValueNode x2 = iv.initNode();
            if (mirrored) {
                x1 = longBound;
                y1 = guardedExtremum;
                x2 = bound;
                y2 = iv.initNode();
            }
            if (compare instanceof IntegerBelowNode) {
                extremumTest = this.graph.addOrUniqueWithInputs(IntegerBelowNode.create(x1, y1, NodeView.DEFAULT));
                initTest = this.graph.addOrUniqueWithInputs(IntegerBelowNode.create(x2, y2, NodeView.DEFAULT));
            } else {
                assert (compare instanceof IntegerLessThanNode) : Assertions.errorMessage(compare);
                extremumTest = this.graph.addOrUniqueWithInputs(IntegerLessThanNode.create(x1, y1, NodeView.DEFAULT));
                initTest = this.graph.addOrUniqueWithInputs(IntegerLessThanNode.create(x2, y2, NodeView.DEFAULT));
            }
            if (this.graph.getDebug().isDumpEnabledForMethod()) {
                if (mirrored) {
                    this.graph.getDebug().dump(5, this.graph, "Speculative guard movement: longBound(%s) |<| guardedExtremum(%s) && bound(%s) |<| iv.initNode()(%s) =%s && %s", x1, y1, x2, y2, extremumTest, initTest);
                } else {
                    this.graph.getDebug().dump(5, this.graph, "Speculative guard movement: guardedExtremum(%s) |<| longBound(%s) && iv.initNode()(%s) |<| bound(%s)=%s && %s", x1, y1, x2, y2, extremumTest, initTest);
                }
            }
            return new OptimizedCompareTests(initTest, extremumTest);
        }

        private LogicNode createLoopEnterCheck(CountedLoopInfo countedLoop, LogicNode newCompare) {
            ValueNode y;
            ValueNode x;
            ValueNode limit = countedLoop.getLimit();
            ValueNode start = countedLoop.getBodyIVStart();
            InductionVariable.Direction direction = countedLoop.getDirection();
            boolean limitIncluded = countedLoop.isLimitIncluded();
            if (limitIncluded) {
                if (direction == InductionVariable.Direction.Up) {
                    x = limit;
                    y = start;
                } else {
                    assert (direction == InductionVariable.Direction.Down) : direction;
                    x = start;
                    y = limit;
                }
            } else if (direction == InductionVariable.Direction.Up) {
                x = start;
                y = limit;
            } else {
                assert (direction == InductionVariable.Direction.Down) : direction;
                x = limit;
                y = start;
            }
            LogicNode compare = countedLoop.getCounterIntegerHelper().createCompareNode(x, y, NodeView.DEFAULT);
            return this.graph.addOrUniqueWithInputs(ShortCircuitOrNode.create(compare, !limitIncluded, newCompare, false, ProfileData.BranchProbabilityData.unknown()));
        }

        private static boolean shouldHoistBasedOnFrequency(HIRBlock proposedNewAnchor, HIRBlock anchorBlock) {
            return SpeculativeGuardMovement.shouldHoistBasedOnFrequency(proposedNewAnchor.getRelativeFrequency(), anchorBlock.getRelativeFrequency());
        }

        private static boolean shouldHoistBasedOnFrequency(double proposedNewAnchorFrequency, double anchorFrequency) {
            return SchedulePhase.Instance.compareRelativeFrequencies(proposedNewAnchorFrequency, anchorFrequency) <= 0;
        }

        private OptimizedCompareTests shouldOptimizeCompare(CompareNode compare, InductionVariable iv, ValueNode bound, GuardNode guard, boolean mirrored) {
            DebugContext debug = guard.getDebug();
            if (!iv.getLoop().isCounted()) {
                debug.log("shouldOptimizeCompare(%s):not a counted loop", guard);
                return null;
            }
            LoopEx loopEx = iv.getLoop();
            Loop<HIRBlock> ivLoop = loopEx.loop();
            HIRBlock guardAnchorBlock = this.earliestBlock(guard.getAnchor().asNode());
            if (SpeculativeGuardMovementPhase.isInverted(iv.getLoop())) {
                if (!this.earliestBlock(iv.getLoop().counted().getBody()).dominates(guardAnchorBlock) && !iv.getLoop().whole().contains(guard.getCondition())) {
                    return null;
                }
            } else if (!this.earliestBlock(iv.getLoop().counted().getBody()).dominates(guardAnchorBlock)) {
                debug.log("shouldOptimizeCompare(%s):guard is not inside loop", guard);
                return null;
            }
            if (!ivLoop.getBlocks().contains(this.earliestBlock(iv.valueNode()))) {
                debug.log("shouldOptimizeCompare(%s):iv is not inside loop", guard);
                return null;
            }
            if (this.earliestBlock(bound).getId() >= ivLoop.getHeader().getId()) {
                debug.log("shouldOptimizeCompare(%s):bound is not schedulable above the IV loop", guard);
                return null;
            }
            CountedLoopInfo countedLoop = loopEx.counted();
            if (!(this.profilingInfo instanceof DefaultProfilingInfo)) {
                double loopFreqThreshold = 1.0;
                if (!(iv.initNode() instanceof ConstantNode) || !(bound instanceof ConstantNode)) {
                    loopFreqThreshold += 2.0;
                }
                if (!(SpeculativeGuardMovementPhase.isInverted(loopEx) || countedLoop.getBodyIVStart() instanceof ConstantNode && countedLoop.getLimit() instanceof ConstantNode)) {
                    loopFreqThreshold += 1.0;
                }
                if (!this.ignoreFrequency && ProfileData.ProfileSource.isTrusted(loopEx.localFrequencySource()) && loopEx.localLoopFrequency() < loopFreqThreshold) {
                    debug.log("shouldOptimizeCompare(%s):loop frequency too low.", guard);
                    return null;
                }
            }
            Loop<HIRBlock> l = guardAnchorBlock.getLoop();
            if (SpeculativeGuardMovementPhase.isInverted(loopEx)) {
                l = iv.getLoop().loop();
            }
            if (l == null) {
                return null;
            }
            assert (l != null) : "Loop for guard anchor block must not be null:" + String.valueOf(guardAnchorBlock.getBeginNode()) + " loop " + String.valueOf(iv.getLoop()) + " inverted?" + SpeculativeGuardMovementPhase.isInverted(iv.getLoop());
            do {
                if (this.allowsSpeculativeGuardMovement(guard.getReason(), (LoopBeginNode)l.getHeader().getBeginNode(), true)) continue;
                debug.log("shouldOptimizeCompare(%s):The guard would not hoist", guard);
                return null;
            } while ((l = l.getParent()) != ivLoop.getParent() && l != null);
            if (!(SpeculativeGuardMovementPhase.isInverted(iv.getLoop()) || guardAnchorBlock.dominates(iv.getLoop().loop().getHeader()) || this.ignoreFrequency || SpeculativeGuardMovement.shouldHoistBasedOnFrequency((HIRBlock)ivLoop.getHeader().getDominator(), guardAnchorBlock))) {
                debug.log("hoisting is not beneficial based on frequency", guard);
                return null;
            }
            Stamp boundStamp = bound.stamp(NodeView.DEFAULT);
            Stamp ivStamp = iv.valueNode().stamp(NodeView.DEFAULT);
            boolean fitsInInt = false;
            if (boundStamp instanceof IntegerStamp && ivStamp instanceof IntegerStamp) {
                IntegerStamp integerBoundStamp = (IntegerStamp)boundStamp;
                IntegerStamp integerIvStamp = (IntegerStamp)ivStamp;
                if (SpeculativeGuardMovement.fitsIn32Bit(integerBoundStamp) && SpeculativeGuardMovement.fitsIn32Bit(integerIvStamp)) {
                    fitsInInt = true;
                }
            }
            if (fitsInInt) {
                OptimizedCompareTests tests;
                CountedLoopInfo countedLoopInfo = iv.getLoop().counted();
                GuardingNode overflowGuard = countedLoopInfo.getOverFlowGuard();
                if (overflowGuard == null && !countedLoopInfo.counterNeverOverflows()) {
                    if (this.graph.getGuardsStage().allowsFloatingGuards()) {
                        overflowGuard = iv.getLoop().counted().createOverFlowGuard();
                    } else {
                        debug.log("shouldOptimizeCompare(%s): abort, cannot create overflow guard", compare);
                        return null;
                    }
                }
                if (SpeculativeGuardMovement.optimizedCompareUnconditionalDeopt(guard, tests = this.computeNewCompareGuards(compare, iv, bound, mirrored, overflowGuard))) {
                    debug.log("shouldOptimizeCompare(%s): guard would immediately deopt", compare);
                    return null;
                }
                if (iv.getLoop().loop().getDepth() > 1 && iv.getLoop().loopBegin().loopExits().count() > 1) {
                    InductionVariable currentIv = iv;
                    LoopEx currentLoop = iv.getLoop();
                    InductionVariable countedLoopInitModifiedIV = iv.getLoop().counted().getBodyIV();
                    boolean initIsParentIV = false;
                    boolean initIsParentPhi = false;
                    ValueNode currentRootInit = currentIv.getRootIV().initNode();
                    while (currentLoop.parent() != null && ((initIsParentIV = currentLoop.parent().getInductionVariables().containsKey((Object)currentRootInit)) || (initIsParentPhi = currentLoop.parent().loopBegin().isPhiAtMerge(currentRootInit)))) {
                        if (initIsParentIV) {
                            InductionVariable parentIv = (InductionVariable)currentLoop.parent().getInductionVariables().get((Object)currentRootInit);
                            currentIv = currentIv.duplicateWithNewInit(parentIv.entryTripValue());
                        } else if (initIsParentPhi) {
                            currentIv = currentIv.duplicateWithNewInit(((PhiNode)currentRootInit).valueAt(0));
                        } else {
                            throw GraalError.shouldNotReachHere("Must have never entered loop");
                        }
                        if (currentLoop.parent().getInductionVariables().containsKey((Object)countedLoopInitModifiedIV.getRootIV().initNode())) {
                            InductionVariable parentIVBodyRef = (InductionVariable)currentLoop.parent().getInductionVariables().get((Object)countedLoopInitModifiedIV.getRootIV().initNode());
                            countedLoopInitModifiedIV = countedLoopInitModifiedIV.duplicateWithNewInit(parentIVBodyRef.entryTripValue());
                        }
                        currentRootInit = currentIv.getRootIV().initNode();
                        currentLoop = currentLoop.parent();
                    }
                    if (currentLoop != iv.getLoop()) {
                        InductionVariable duplicateOriginalLoopIV = currentIv;
                        ValueNode newBodyIVInit = countedLoopInitModifiedIV.initNode();
                        this.graph.getDebug().dump(5, this.graph, "SpeculativeGuardMovement: new if for outer loop check %s %s", duplicateOriginalLoopIV.valueNode(), duplicateOriginalLoopIV);
                        CountedLoopInfo thisLoopCounted = iv.getLoop().counted();
                        ValueNode outerLoopInitBasedMaxTripCount = thisLoopCounted.maxTripCountNode(true, thisLoopCounted.getCounterIntegerHelper(), newBodyIVInit, thisLoopCounted.getTripCountLimit());
                        OptimizedCompareTests testStripMinedIV = this.computeNewCompareGuards(compare, duplicateOriginalLoopIV, bound, mirrored, iv.getLoop().counted().getOverFlowGuard(), outerLoopInitBasedMaxTripCount);
                        if (SpeculativeGuardMovement.optimizedCompareUnconditionalDeopt(guard, testStripMinedIV)) {
                            debug.log("shouldOptimizeCompare(%s): guard would immediately deopt in loop", compare);
                            return null;
                        }
                    }
                }
                return tests;
            }
            debug.log("shouldOptimizeCompare(%s): bound or iv does not fit in int", guard);
            return null;
        }

        private static boolean optimizedCompareUnconditionalDeopt(GuardNode guard, OptimizedCompareTests tests) {
            if (tests.extremumTestIsConstant() || tests.initTestIsConstant()) {
                boolean t1 = tests.constantExtremumTestOrValue(true);
                boolean t2 = tests.constantInitTestOrValue(true);
                boolean result = t1 && t2;
                return result == guard.deoptsOnTrue();
            }
            return false;
        }

        private static boolean fitsIn32Bit(IntegerStamp stamp) {
            return NumUtil.isUInt(stamp.mayBeSet());
        }

        private Loop<HIRBlock> tryOptimizeInstanceOf(GuardNode guard, InstanceOfNode compare) {
            AnchoringNode anchor = compare.getAnchor();
            if (anchor == null) {
                return null;
            }
            HIRBlock anchorBlock = this.earliestBlock(anchor.asNode());
            if (anchorBlock.getLoop() == null) {
                return null;
            }
            HIRBlock valueBlock = this.earliestBlock(compare.getValue());
            Loop<HIRBlock> hoistAbove = this.findInstanceOfLoopHoisting(guard, anchorBlock, valueBlock);
            if (hoistAbove != null) {
                compare.setProfile(compare.profile(), ((HIRBlock)hoistAbove.getHeader().getDominator()).getBeginNode());
                this.graph.getOptimizationLog().report(SpeculativeGuardMovementPhase.class, "InstanceOfOptimization", compare);
                return hoistAbove;
            }
            return null;
        }

        private Loop<HIRBlock> findInstanceOfLoopHoisting(GuardNode guard, HIRBlock anchorBlock, HIRBlock valueBlock) {
            assert (anchorBlock.getLoop() != null);
            DebugContext debug = guard.getDebug();
            if (valueBlock.getLoop() == anchorBlock.getLoop()) {
                debug.log("shouldOptimizeInstanceOf(%s): anchor and condition in the same loop", guard);
                return null;
            }
            if (!valueBlock.isInSameOrOuterLoopOf(anchorBlock)) {
                debug.log("shouldOptimizeInstanceOf(%s): condition loop is not a parent of anchor loop", guard);
                return null;
            }
            if (!valueBlock.dominates(anchorBlock)) {
                debug.log("shouldOptimizeInstanceOf(%s): value block does not dominate loop header", guard);
                return null;
            }
            if (!this.allowsSpeculativeGuardMovement(guard.getReason(), (LoopBeginNode)anchorBlock.getLoop().getHeader().getBeginNode(), true)) {
                debug.log("shouldOptimizeInstanceOf(%s): The guard would not hoist", guard);
                return null;
            }
            Loop<HIRBlock> hoistFrom = anchorBlock.getLoop();
            Loop<HIRBlock> curLoop = anchorBlock.getLoop();
            while (curLoop.getParent() != valueBlock.getLoop()) {
                curLoop = curLoop.getParent();
                if (!this.allowsSpeculativeGuardMovement(guard.getReason(), (LoopBeginNode)curLoop.getHeader().getBeginNode(), true)) break;
                if (!this.ignoreFrequency && !SpeculativeGuardMovement.shouldHoistBasedOnFrequency((HIRBlock)curLoop.getHeader().getDominator(), (HIRBlock)hoistFrom.getHeader().getDominator())) continue;
                hoistFrom = curLoop;
            }
            if (!this.ignoreFrequency && !SpeculativeGuardMovement.shouldHoistBasedOnFrequency((HIRBlock)hoistFrom.getHeader().getDominator(), anchorBlock)) {
                debug.log("hoisting is not beneficial based on frequency", guard);
                return null;
            }
            return hoistFrom;
        }

        private HIRBlock earliestBlockForGuard(GuardNode guard, Loop<HIRBlock> forcedHoisting) {
            DebugContext debug = guard.getDebug();
            ValueNode anchor = guard.getAnchor().asNode();
            assert (guard.inputs().count() == 2) : Assertions.errorMessage(guard.inputs());
            HIRBlock conditionEarliest = this.earliestBlock(guard.getCondition());
            HIRBlock anchorEarliest = this.earliestBlock(anchor);
            HIRBlock newAnchorEarliest = null;
            LoopBeginNode outerMostExitedLoop = null;
            HIRBlock b = anchorEarliest;
            if (forcedHoisting != null) {
                newAnchorEarliest = (HIRBlock)forcedHoisting.getHeader().getDominator();
                if (anchorEarliest.strictlyDominates(newAnchorEarliest)) {
                    newAnchorEarliest = anchorEarliest;
                }
                outerMostExitedLoop = (LoopBeginNode)forcedHoisting.getHeader().getBeginNode();
                b = newAnchorEarliest;
            }
            debug.log("earliestBlockForGuard(%s) inital anchor : %s, condition : %s condition's earliest %s", guard, (Object)anchor, (Object)guard.getCondition(), (Object)conditionEarliest.getBeginNode());
            double minFrequency = anchorEarliest.getRelativeFrequency();
            while (conditionEarliest.strictlyDominates(b)) {
                HIRBlock candidateAnchor = (HIRBlock)b.getDominatorSkipLoops();
                assert (candidateAnchor.getLoopDepth() <= anchorEarliest.getLoopDepth()) : " candidate anchor block at begin node " + String.valueOf(candidateAnchor.getBeginNode()) + " earliest anchor block " + String.valueOf(anchorEarliest.getBeginNode()) + " loop depth is not smaller equal for guard " + String.valueOf(guard);
                if (b.isLoopHeader() && (newAnchorEarliest == null || candidateAnchor.getLoopDepth() < newAnchorEarliest.getLoopDepth())) {
                    LoopBeginNode loopBegin = (LoopBeginNode)b.getBeginNode();
                    if (!this.allowsSpeculativeGuardMovement(guard.getReason(), loopBegin, true)) break;
                    double candidateFrequency = candidateAnchor.getRelativeFrequency();
                    if (this.ignoreFrequency || SpeculativeGuardMovement.shouldHoistBasedOnFrequency(candidateFrequency, minFrequency)) {
                        debug.log("earliestBlockForGuard(%s) hoisting above %s", (Object)guard, (Object)loopBegin);
                        outerMostExitedLoop = loopBegin;
                        newAnchorEarliest = candidateAnchor;
                        minFrequency = candidateFrequency;
                    } else {
                        debug.log("earliestBlockForGuard(%s) %s not worth it, old relative frequency %f, new relative frequency %f", guard, (Object)loopBegin, (Object)minFrequency, (Object)candidateFrequency);
                    }
                }
                b = candidateAnchor;
            }
            if (newAnchorEarliest != null && this.allowsSpeculativeGuardMovement(guard.getReason(), outerMostExitedLoop, false)) {
                AbstractBeginNode newAnchor = newAnchorEarliest.getBeginNode();
                guard.setAnchor(newAnchor);
                debug.log("New earliest : %s, anchor is %s, update guard", (Object)newAnchorEarliest.getBeginNode(), (Object)anchor);
                HIRBlock earliest = newAnchorEarliest;
                if (guard.getAction() == DeoptimizationAction.None) {
                    guard.setAction(DeoptimizationAction.InvalidateRecompile);
                }
                guard.setSpeculation(this.registerSpeculativeGuardMovement(guard.getReason(), outerMostExitedLoop));
                debug.log("Exited %d loops for %s %s in %s", anchorEarliest.getLoopDepth() - earliest.getLoopDepth(), (Object)guard, (Object)guard.getCondition(), (Object)this.graph.method());
                return earliest;
            }
            debug.log("Keep normal anchor edge");
            return conditionEarliest.strictlyDominates(anchorEarliest) ? anchorEarliest : conditionEarliest;
        }

        private boolean allowsSpeculativeGuardMovement(DeoptimizationReason reason, LoopBeginNode loopBeginNode, boolean checkDeoptimizationCount) {
            DebugContext debug = loopBeginNode.getDebug();
            if (this.speculationLog != null) {
                SpeculationLog.SpeculationReason speculation = SpeculativeGuardMovementPhase.createSpeculation(reason, loopBeginNode);
                if (this.speculationLog.maySpeculate(speculation)) {
                    return true;
                }
                debug.log("Preventing Speculative Guard Motion because of speculation log: %s", speculation);
                return false;
            }
            if (checkDeoptimizationCount && this.profilingInfo != null) {
                if (this.profilingInfo.getDeoptimizationCount(DeoptimizationReason.LoopLimitCheck) > 1) {
                    debug.log("Preventing Speculative Guard Motion because of failed LoopLimitCheck");
                    return false;
                }
                if (this.profilingInfo.getDeoptimizationCount(reason) > 2) {
                    debug.log("Preventing Speculative Guard Motion because of deopt count for reason: %s", reason);
                    return false;
                }
            }
            debug.log("Allowing Speculative Guard Motion but we can not speculate: %s", loopBeginNode);
            return true;
        }

        private SpeculationLog.Speculation registerSpeculativeGuardMovement(DeoptimizationReason reason, LoopBeginNode loopBeginNode) {
            assert (this.allowsSpeculativeGuardMovement(reason, loopBeginNode, false));
            if (this.speculationLog != null) {
                return this.speculationLog.speculate(SpeculativeGuardMovementPhase.createSpeculation(reason, loopBeginNode));
            }
            loopBeginNode.getDebug().log("No log or state :(");
            return SpeculationLog.NO_SPECULATION;
        }

        private static class OptimizedCompareTests {
            LogicNode initTest;
            LogicNode extremumTest;

            OptimizedCompareTests(LogicNode initTest, LogicNode extremumTest) {
                this.initTest = initTest;
                this.extremumTest = extremumTest;
            }

            private static boolean isLogicConstant(ValueNode v) {
                return v instanceof LogicConstantNode;
            }

            private boolean constantInitTestOrValue(boolean value) {
                if (this.initTestIsConstant()) {
                    return this.initTestAsConstant();
                }
                return value;
            }

            private boolean constantExtremumTestOrValue(boolean value) {
                if (this.extremumTestIsConstant()) {
                    return this.extremumTestAsConstant();
                }
                return value;
            }

            private boolean initTestAsConstant() {
                assert (OptimizedCompareTests.isLogicConstant(this.initTest));
                return ((LogicConstantNode)this.initTest).getValue();
            }

            private boolean extremumTestAsConstant() {
                assert (OptimizedCompareTests.isLogicConstant(this.extremumTest));
                return ((LogicConstantNode)this.extremumTest).getValue();
            }

            private boolean initTestIsConstant() {
                return OptimizedCompareTests.isLogicConstant(this.initTest);
            }

            private boolean extremumTestIsConstant() {
                return OptimizedCompareTests.isLogicConstant(this.extremumTest);
            }
        }
    }
}

