/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.LIRLowerableLogicNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.vm.ci.meta.TriState;

@NodeInfo
public abstract class BinaryOpLogicNode
extends LIRLowerableLogicNode
implements Canonicalizable.Binary<ValueNode> {
    public static final NodeClass<BinaryOpLogicNode> TYPE = NodeClass.create(BinaryOpLogicNode.class);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode y;

    @Override
    public ValueNode getX() {
        return this.x;
    }

    @Override
    public ValueNode getY() {
        return this.y;
    }

    public void setX(ValueNode newX) {
        assert (newX != null);
        this.updateUsages(this.x, newX);
        this.x = newX;
    }

    public void setY(ValueNode newY) {
        assert (newY != null);
        this.updateUsages(this.y, newY);
        this.y = newY;
    }

    public BinaryOpLogicNode(NodeClass<? extends BinaryOpLogicNode> c, ValueNode x, ValueNode y) {
        super((NodeClass<? extends LIRLowerableLogicNode>)c);
        assert (x != null);
        assert (y != null);
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean verify() {
        return super.verify();
    }

    public LogicNode maybeCommuteInputs() {
        assert (this instanceof Canonicalizable.BinaryCommutative) : Assertions.errorMessageContext("this", this);
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            LogicNode duplicate;
            ValueNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (LogicNode)this.graph().findDuplicate(this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    public abstract Stamp getSucceedingStampForX(boolean var1, Stamp var2, Stamp var3);

    public abstract Stamp getSucceedingStampForY(boolean var1, Stamp var2, Stamp var3);

    public abstract TriState tryFold(Stamp var1, Stamp var2);
}

