/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(nameTemplate="{p#op/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class CompressionNode
extends UnaryNode
implements ConvertNode,
LIRLowerable {
    public static final NodeClass<CompressionNode> TYPE = NodeClass.create(CompressionNode.class);
    protected final CompressionOp op;
    protected final CompressEncoding encoding;

    public CompressionNode(NodeClass<? extends UnaryNode> c, CompressionOp op, ValueNode input, Stamp stamp, CompressEncoding encoding) {
        super(c, stamp, input);
        this.op = op;
        this.encoding = encoding;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return this.stamp.improveWith(this.mkStamp(newStamp));
    }

    protected abstract Constant compress(Constant var1);

    protected abstract Constant uncompress(Constant var1);

    public JavaConstant nullConstant() {
        return JavaConstant.NULL_POINTER;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        switch (this.op.ordinal()) {
            case 0: {
                return this.compress(c);
            }
            case 1: {
                return this.uncompress(c);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        switch (this.op.ordinal()) {
            case 0: {
                return this.uncompress(c);
            }
            case 1: {
                return this.compress(c);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
    }

    public abstract ValueNode reverse(ValueNode var1);

    @Override
    public boolean isLossless() {
        return true;
    }

    protected abstract Stamp mkStamp(Stamp var1);

    public CompressionOp getOp() {
        return this.op;
    }

    public CompressEncoding getEncoding() {
        return this.encoding;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            ConstantNode constant = (ConstantNode)forValue;
            return ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), this.convert(constant.getValue(), tool.getConstantReflection()), constant.getStableDimension(), constant.isDefaultStable(), tool.getMetaAccess());
        }
        if (forValue instanceof CompressionNode) {
            CompressionNode other = (CompressionNode)forValue;
            if (this.op != other.op && this.encoding.equals(other.encoding)) {
                return other.getValue();
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        boolean nonNull = this.stamp instanceof AbstractObjectStamp ? StampTool.isPointerNonNull(this.stamp) : true;
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        gen.setResult(this, switch (this.op.ordinal()) {
            case 0 -> tool.emitCompress(gen.operand(this.value), this.encoding, nonNull);
            case 1 -> tool.emitUncompress(gen.operand(this.value), this.encoding, nonNull);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
        });
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return true;
    }

    public static enum CompressionOp {
        Compress,
        Uncompress;

    }
}

