/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public final class DynamicPiNode
extends PiNode {
    public static final NodeClass<DynamicPiNode> TYPE = NodeClass.create(DynamicPiNode.class);
    @Node.Input
    ValueNode typeMirror;
    private final boolean exact;
    private final boolean allowsNull;

    protected DynamicPiNode(ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean allowsNull, boolean exact) {
        super(TYPE, object, StampFactory.object(), guard);
        this.typeMirror = typeMirror;
        this.exact = exact;
        this.allowsNull = allowsNull;
    }

    public static ValueNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean allowsNull, boolean exact) {
        ValueNode synonym = DynamicPiNode.findSynonym(assumptions, constantReflection, object, guard, typeMirror, allowsNull, exact);
        if (synonym != null) {
            return synonym;
        }
        return new DynamicPiNode(object, guard, typeMirror, allowsNull, exact);
    }

    public static ValueNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror) {
        return DynamicPiNode.create(assumptions, constantReflection, object, guard, typeMirror, true, false);
    }

    private static ValueNode findSynonym(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean allowsNull, boolean exact) {
        ResolvedJavaType t;
        if (typeMirror.isConstant() && (t = constantReflection.asJavaType(typeMirror.asConstant())) != null) {
            Stamp staticPiStamp;
            if (t.isPrimitive()) {
                staticPiStamp = StampFactory.alwaysNull();
            } else {
                TypeReference type = exact ? TypeReference.createExactTrusted(t) : TypeReference.createTrusted(assumptions, t);
                staticPiStamp = allowsNull ? StampFactory.object(type) : StampFactory.objectNonNull(type);
            }
            return DynamicPiNode.create(object, staticPiStamp, (ValueNode)((Object)guard));
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = DynamicPiNode.findSynonym(tool.getAssumptions(), tool.getConstantReflection(), this.object, this.guard, this.typeMirror, this.allowsNull, this.exact);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }
}

