/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractFixedGuardNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.SwitchFoldable;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;

@NodeInfo(nameTemplate="FixedGuard(!={p#negated}) {p#reason/s}", allowedUsageTypes={InputType.Guard}, size=NodeSize.SIZE_2, cycles=NodeCycles.CYCLES_2)
public final class FixedGuardNode
extends AbstractFixedGuardNode
implements Lowerable,
IterableNodeType,
SwitchFoldable {
    public static final NodeClass<FixedGuardNode> TYPE = NodeClass.create(FixedGuardNode.class);

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, false);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, boolean negated) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, negated);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, negated, noDeoptSuccessorPosition);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated) {
        super(TYPE, condition, deoptReason, action, speculation, negated);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
        super(TYPE, condition, deoptReason, action, speculation, negated, noDeoptSuccessorPosition);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        super.simplify(tool);
        if (this.getCondition() instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)this.getCondition();
            if (c.getValue() == this.isNegated()) {
                DeoptimizeNode deopt = this.graph().add(new DeoptimizeNode(this.getAction(), this.getReason(), this.getSpeculation()));
                deopt.setStateBefore(this.stateBefore());
                this.predecessor().replaceFirstSuccessor(this, deopt);
                GraphUtil.killCFG(this);
                return;
            }
            if (this.hasUsages()) {
                PiNode.tryEvacuate(tool, this);
            }
            if (this.hasUsages()) {
                this.graph().replaceFixedWithFixed(this, this.graph().add(new ValueAnchorNode()));
            } else {
                this.graph().removeFixed(this);
            }
        } else if (this.getCondition() instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOr = (ShortCircuitOrNode)this.getCondition();
            if (this.isNegated() && this.hasNoUsages()) {
                this.graph().addAfterFixed(this, this.graph().add(new FixedGuardNode(shortCircuitOr.getY(), this.getReason(), this.getAction(), this.getSpeculation(), !shortCircuitOr.isYNegated(), this.getNoDeoptSuccessorPosition())));
                this.graph().replaceFixedWithFixed(this, this.graph().add(new FixedGuardNode(shortCircuitOr.getX(), this.getReason(), this.getAction(), this.getSpeculation(), !shortCircuitOr.isXNegated(), this.getNoDeoptSuccessorPosition())));
            }
        }
    }

    public boolean canFloat() {
        return DeoptimizeNode.canFloat(this.getReason(), this.getAction());
    }

    @Override
    public void lower(LoweringTool tool) {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            if (this.graph().getGuardsStage().allowsFloatingGuards()) {
                if (this.canFloat()) {
                    ValueNode guard = tool.createGuard(this, this.getCondition(), this.getReason(), this.getAction(), this.getSpeculation(), this.isNegated(), this.getNoDeoptSuccessorPosition()).asNode();
                    this.replaceAtUsages(guard);
                    this.graph().removeFixed(this);
                }
            } else {
                this.lowerToIf().lower(tool);
            }
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public Node getNextSwitchFoldableBranch() {
        return this.next();
    }

    @Override
    public boolean isInSwitch(ValueNode switchValue) {
        return this.hasNoUsages() && this.isNegated() && SwitchFoldable.maybeIsInSwitch(this.condition()) && SwitchFoldable.sameSwitchValue(this.condition(), switchValue);
    }

    @Override
    public void cutOffCascadeNode() {
    }

    @Override
    public void cutOffLowestCascadeNode() {
        this.setNext(null);
    }

    @Override
    public boolean isDefaultSuccessor(AbstractBeginNode beginNode) {
        return beginNode.next() == this.next();
    }

    @Override
    public AbstractBeginNode getDefault() {
        FixedNode defaultNode = this.next();
        this.setNext(null);
        return BeginNode.begin(defaultNode);
    }

    @Override
    public ValueNode switchValue() {
        if (SwitchFoldable.maybeIsInSwitch(this.condition())) {
            return ((IntegerEqualsNode)this.condition()).getX();
        }
        return null;
    }

    @Override
    public boolean isNonInitializedProfile() {
        return true;
    }

    @Override
    public ProfileData.ProfileSource profileSource() {
        return ProfileData.ProfileSource.INJECTED;
    }

    @Override
    public int intKeyAt(int i) {
        assert (i == 0) : i;
        return ((IntegerEqualsNode)this.condition()).getY().asJavaConstant().asInt();
    }

    @Override
    public double keyProbability(int i) {
        return 0.0;
    }

    @Override
    public AbstractBeginNode keySuccessor(int i) {
        DeoptimizeNode deopt = new DeoptimizeNode(this.getAction(), this.getReason(), this.getSpeculation());
        deopt.setNodeSourcePosition(this.getNodeSourcePosition());
        BeginNode begin = new BeginNode();
        begin.next = deopt;
        return begin;
    }

    @Override
    public double defaultProbability() {
        return 1.0;
    }

    public boolean willDeoptUnconditionally() {
        if (this.getCondition() instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)this.getCondition();
            return c.getValue() == this.negated;
        }
        return false;
    }
}

