/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FloatingGuardedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class GuardedValueNode
extends FloatingGuardedNode
implements LIRLowerable,
Virtualizable,
Canonicalizable,
ValueProxy {
    public static final NodeClass<GuardedValueNode> TYPE = NodeClass.create(GuardedValueNode.class);
    @Node.Input
    ValueNode object;

    public GuardedValueNode(ValueNode object, GuardingNode guard) {
        super(TYPE, object.stamp(NodeView.DEFAULT), guard);
        this.object = object;
    }

    public ValueNode object() {
        return this.object;
    }

    public static ValueNode create(ValueNode object, GuardingNode guard) {
        ValueNode canonical = GuardedValueNode.canonicalize(guard, object);
        if (canonical != null) {
            return canonical;
        }
        return new GuardedValueNode(object, guard);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (this.object.getStackKind() != JavaKind.Void && this.object.getStackKind() != JavaKind.Illegal) {
            generator.setResult(this, generator.operand(this.object));
        }
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.object().stamp(NodeView.DEFAULT));
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            tool.replaceWithVirtual((VirtualObjectNode)alias);
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode canonical = GuardedValueNode.canonicalize(this.guard, this.object);
        if (canonical != null && canonical != this) {
            return canonical;
        }
        return this;
    }

    static ValueNode canonicalize(GuardingNode guard, ValueNode object) {
        if (guard == null) {
            return object;
        }
        if (object instanceof ConstantNode) {
            return object;
        }
        return null;
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.object;
    }
}

