/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.DeoptBciSupplier;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface Invokable
extends DeoptBciSupplier {
    public ResolvedJavaMethod getTargetMethod();

    public ResolvedJavaMethod getContextMethod();

    default public ResolvedJavaType getContextType() {
        ResolvedJavaMethod contextMethod = this.getContextMethod();
        if (contextMethod == null) {
            return null;
        }
        return contextMethod.getDeclaringClass();
    }

    default public FixedNode asFixedNodeOrNull() {
        return this instanceof FixedNode ? (FixedNode)((Object)this) : null;
    }

    default public void updateInliningLogAfterRegister(StructuredGraph newGraph) {
        InliningLog log = newGraph.getInliningLog();
        if (log != null) {
            if (log.getUpdateScope() != null) {
                log.getUpdateScope().accept(null, this);
            } else {
                if (!1.$assertionsDisabled && log.containsLeafCallsite(this)) {
                    throw new AssertionError();
                }
                log.trackNewCallsite(this);
            }
        }
    }

    default public void updateInliningLogAfterClone(Node other) {
        StructuredGraph graph = this.asFixedNodeOrNull().graph();
        if (graph == null) {
            return;
        }
        InliningLog log = graph.getInliningLog();
        if (log != null) {
            if (!1.$assertionsDisabled && !(other instanceof Invokable)) {
                throw new AssertionError((Object)Assertions.errorMessage(other));
            }
            if (log.getUpdateScope() != null) {
                log.getUpdateScope().accept((Invokable)((Object)other), this);
            } else if (other.graph() == graph) {
                if (!1.$assertionsDisabled && !log.containsLeafCallsite(this)) {
                    throw new AssertionError((Object)("Node " + String.valueOf(this) + " not contained in the log."));
                }
                if (!1.$assertionsDisabled && !log.containsLeafCallsite((Invokable)((Object)other))) {
                    throw new AssertionError((Object)("Sibling " + String.valueOf(other) + " not contained in the log."));
                }
                log.removeLeafCallsite(this);
                log.trackDuplicatedCallsite((Invokable)((Object)other), this, null);
            } else {
                throw GraalError.shouldNotReachHere("No InliningLog.Update scope provided.");
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

