/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Iterator;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

@NodeInfo
public final class LoopBeginNode
extends AbstractMergeNode
implements IterableNodeType,
LIRLowerable {
    public static final NodeClass<LoopBeginNode> TYPE = NodeClass.create(LoopBeginNode.class);
    protected double loopOrigFrequency = 1.0;
    protected int nextEndIndex;
    protected int unswitches = 0;
    protected int splits = 0;
    protected int peelings;
    protected boolean compilerInverted;
    protected LoopType loopType = LoopType.SIMPLE_LOOP;
    protected int unrollFactor = 1;
    protected boolean osrLoop;
    protected boolean stripMinedOuter;
    protected boolean stripMinedInner;
    protected boolean rotated;
    protected int stripMinedLimit = -1;
    protected boolean disableCounted;
    protected boolean canNeverOverflow;
    @Node.OptionalInput(value=InputType.Guard)
    protected GuardingNode protectedNonOverflowingUnsigned;
    boolean canEndsSafepoint = true;
    boolean canEndsGuestSafepoint = true;
    @Node.OptionalInput(value=InputType.Guard)
    GuardingNode overflowGuard;
    @Node.OptionalInput(value=InputType.Guard)
    GuardingNode interIterationAliasingGuard;
    public static final CounterKey overflowSpeculationTaken = DebugContext.counter("CountedLoops_OverflowSpeculation_Taken");
    public static final CounterKey overflowSpeculationNotTaken = DebugContext.counter("CountedLoops_OverflowSpeculation_NotTaken");
    public static final SpeculationReasonGroup LOOP_OVERFLOW_DEOPT = new SpeculationReasonGroup("LoopOverflowDeopt", ResolvedJavaMethod.class, Integer.TYPE);
    private static final int NO_INCREMENT = Integer.MIN_VALUE;

    public GuardingNode getUnsignedRangeGuard() {
        return this.protectedNonOverflowingUnsigned;
    }

    public void setUnsignedRangeGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.protectedNonOverflowingUnsigned, guard);
        this.protectedNonOverflowingUnsigned = guard;
    }

    public boolean isProtectedNonOverflowingUnsigned() {
        return this.protectedNonOverflowingUnsigned != null;
    }

    public LoopBeginNode() {
        super((NodeClass<? extends AbstractMergeNode>)TYPE);
    }

    public void checkDisableCountedBySpeculation(int bci, StructuredGraph graph) {
        SpeculationLog.SpeculationReason speculationReason;
        SpeculationLog speculationLog = graph.getSpeculationLog();
        boolean disableCountedBasedOnSpeculation = false;
        if (speculationLog != null && !speculationLog.maySpeculate(speculationReason = LOOP_OVERFLOW_DEOPT.createSpeculationReason(graph.method(), bci))) {
            overflowSpeculationNotTaken.increment(graph.getDebug());
            disableCountedBasedOnSpeculation = true;
        }
        this.disableCounted = disableCountedBasedOnSpeculation;
    }

    public void setStripMinedLimit(int stripMinedLimit) {
        this.stripMinedLimit = stripMinedLimit;
    }

    public int getStripMinedLimit() {
        return this.stripMinedLimit;
    }

    public boolean canEndsSafepoint() {
        return this.canEndsSafepoint;
    }

    public boolean canEndsGuestSafepoint() {
        return this.canEndsGuestSafepoint;
    }

    public void setStripMinedInner(boolean stripMinedInner) {
        this.stripMinedInner = stripMinedInner;
    }

    public void setStripMinedOuter(boolean stripMinedOuter) {
        this.stripMinedOuter = stripMinedOuter;
    }

    public boolean isStripMinedInner() {
        return this.stripMinedInner;
    }

    public boolean isStripMinedOuter() {
        return this.stripMinedOuter;
    }

    public boolean canNeverOverflow() {
        return this.canNeverOverflow;
    }

    public boolean canOverflow() {
        return !this.canNeverOverflow();
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public void setRotated(boolean rotated) {
        this.rotated = rotated;
    }

    public void setCanNeverOverflow() {
        assert (!this.canNeverOverflow);
        this.canNeverOverflow = true;
    }

    public boolean countedLoopDisabled() {
        return this.disableCounted;
    }

    public boolean isSimpleLoop() {
        return this.loopType == LoopType.SIMPLE_LOOP;
    }

    public void setPreLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.PRE_LOOP;
    }

    public boolean isPreLoop() {
        return this.loopType == LoopType.PRE_LOOP;
    }

    public void setMainLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.MAIN_LOOP;
    }

    public boolean isMainLoop() {
        return this.loopType == LoopType.MAIN_LOOP;
    }

    public void setPostLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.POST_LOOP;
    }

    public boolean isPostLoop() {
        return this.loopType == LoopType.POST_LOOP;
    }

    public int getUnrollFactor() {
        return this.unrollFactor;
    }

    public void setUnrollFactor(int currentUnrollFactor) {
        this.unrollFactor = currentUnrollFactor;
    }

    public void disableSafepoint() {
        this.canEndsSafepoint = false;
        for (LoopEndNode loopEnd : this.loopEnds()) {
            loopEnd.disableSafepoint();
        }
    }

    public void disableGuestSafepoint() {
        this.canEndsGuestSafepoint = false;
        for (LoopEndNode loopEnd : this.loopEnds()) {
            loopEnd.disableGuestSafepoint();
        }
    }

    public double loopOrigFrequency() {
        return this.loopOrigFrequency;
    }

    public void setLoopOrigFrequency(double loopOrigFrequency) {
        assert (NumUtil.assertNonNegativeDouble(loopOrigFrequency));
        this.loopOrigFrequency = loopOrigFrequency;
    }

    public NodeIterable<LoopEndNode> loopEnds() {
        return this.usages().filter(LoopEndNode.class);
    }

    public NodeIterable<LoopExitNode> loopExits() {
        return this.usages().filter(LoopExitNode.class);
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(NodePredicates.isNotA(LoopEndNode.class).nor(LoopExitNode.class));
    }

    public LoopEndNode[] orderedLoopEnds() {
        LoopEndNode[] result = new LoopEndNode[this.getLoopEndCount()];
        Iterator iterator = this.loopEnds().iterator();
        while (iterator.hasNext()) {
            LoopEndNode end;
            result[end.endIndex()] = end = (LoopEndNode)iterator.next();
        }
        return result;
    }

    public EndNode forwardEnd() {
        assert (this.forwardEndCount() == 1) : this.forwardEnds();
        return this.forwardEndAt(0);
    }

    public void incrementSplits() {
        ++this.splits;
    }

    public int peelings() {
        return this.peelings;
    }

    public void incrementPeelings() {
        ++this.peelings;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    @Override
    protected void deleteEnd(AbstractEndNode end) {
        if (end instanceof LoopEndNode) {
            LoopEndNode loopEnd = (LoopEndNode)end;
            loopEnd.setLoopBegin(null);
            int idx = loopEnd.endIndex();
            for (LoopEndNode le : this.loopEnds()) {
                int leIdx = le.endIndex();
                assert (leIdx != idx) : Assertions.errorMessageContext("this", this, "end", end, "otherEnd", le);
                if (leIdx <= idx) continue;
                le.setEndIndex(leIdx - 1);
            }
            --this.nextEndIndex;
        } else {
            super.deleteEnd(end);
        }
    }

    @Override
    public int phiPredecessorCount() {
        return this.forwardEndCount() + this.loopEnds().count();
    }

    @Override
    public int phiPredecessorIndex(AbstractEndNode pred) {
        if (pred instanceof LoopEndNode) {
            LoopEndNode loopEnd = (LoopEndNode)pred;
            if (loopEnd.loopBegin() == this) {
                assert (loopEnd.endIndex() < this.loopEnds().count()) : "Invalid endIndex : " + String.valueOf(loopEnd);
                return loopEnd.endIndex() + this.forwardEndCount();
            }
        } else {
            return super.forwardEndIndex((EndNode)pred);
        }
        throw GraalError.shouldNotReachHere("unknown pred : " + String.valueOf(pred));
    }

    @Override
    public AbstractEndNode phiPredecessorAt(int index) {
        if (index < this.forwardEndCount()) {
            return this.forwardEndAt(index);
        }
        for (LoopEndNode end : this.loopEnds()) {
            int idx = index - this.forwardEndCount();
            assert (NumUtil.assertNonNegativeInt(idx));
            if (end.endIndex() != idx) continue;
            return end;
        }
        throw GraalError.shouldNotReachHere("unknown index: " + index);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.loopEnds().isNotEmpty(), "missing loopEnd", new Object[0]);
        return super.verify();
    }

    int nextEndIndex() {
        return this.nextEndIndex++;
    }

    public int getLoopEndCount() {
        return this.nextEndIndex;
    }

    public int unswitches() {
        return this.unswitches;
    }

    public void incrementUnswitches() {
        ++this.unswitches;
    }

    public boolean isCompilerInverted() {
        return this.compilerInverted;
    }

    public void setCompilerInverted() {
        assert (!this.compilerInverted);
        this.compilerInverted = true;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        this.canonicalizePhis(tool);
    }

    public boolean isLoopExit(AbstractBeginNode begin) {
        return begin instanceof LoopExitNode && ((LoopExitNode)begin).loopBegin() == this;
    }

    public LoopEndNode getSingleLoopEnd() {
        assert (this.loopEnds().count() == 1) : this.loopEnds();
        return this.loopEnds().first();
    }

    public void removeExits(boolean forKillCFG) {
        for (LoopExitNode loopexit : this.loopExits().snapshot()) {
            DebugCloseable position = this.graph().withNodeSourcePosition(loopexit);
            try {
                loopexit.removeExit(forKillCFG);
            }
            finally {
                if (position == null) continue;
                position.close();
            }
        }
    }

    public GuardingNode getOverflowGuard() {
        return this.overflowGuard;
    }

    public void setOverflowGuard(GuardingNode overflowGuard) {
        this.updateUsagesInterface(this.overflowGuard, overflowGuard);
        this.overflowGuard = overflowGuard;
    }

    public GuardingNode getInterIterationAliasingGuard() {
        return this.interIterationAliasingGuard;
    }

    public void setInterIterationAliasingGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.interIterationAliasingGuard, guard);
        this.interIterationAliasingGuard = guard;
    }

    private static int[] getSelfIncrements(PhiNode phi) {
        int[] selfIncrement = new int[phi.valueCount()];
        for (int i = 0; i < phi.valueCount(); ++i) {
            ValueNode input = phi.valueAt(i);
            long increment = Integer.MIN_VALUE;
            if (input != null && input instanceof AddNode && input.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                AddNode add = (AddNode)input;
                if (add.getX() == phi && add.getY().isConstant()) {
                    increment = add.getY().asJavaConstant().asLong();
                } else if (add.getY() == phi && add.getX().isConstant()) {
                    increment = add.getX().asJavaConstant().asLong();
                }
            } else if (input == phi) {
                increment = 0L;
            }
            if (increment < Integer.MIN_VALUE || increment > Integer.MAX_VALUE || increment == Integer.MIN_VALUE) {
                increment = Integer.MIN_VALUE;
            }
            selfIncrement[i] = (int)increment;
        }
        return selfIncrement;
    }

    public void canonicalizePhis(SimplifierTool tool) {
        int phiCount = this.phis().count();
        if (phiCount > 1) {
            int phiInputCount = this.phiPredecessorCount();
            int phiIndex = 0;
            int[][] selfIncrement = new int[phiCount][];
            PhiNode[] phis = this.phis().snapshot().toArray(new PhiNode[phiCount]);
            for (phiIndex = 0; phiIndex < phiCount; ++phiIndex) {
                PhiNode phi = phis[phiIndex];
                if (phi == null) continue;
                block1: for (int otherPhiIndex = phiIndex + 1; otherPhiIndex < phiCount; ++otherPhiIndex) {
                    PhiNode otherPhi = phis[otherPhiIndex];
                    if (otherPhi == null || phi.getNodeClass() != otherPhi.getNodeClass() || !phi.valueEquals(otherPhi)) continue;
                    if (selfIncrement[phiIndex] == null) {
                        selfIncrement[phiIndex] = LoopBeginNode.getSelfIncrements(phi);
                    }
                    if (selfIncrement[otherPhiIndex] == null) {
                        selfIncrement[otherPhiIndex] = LoopBeginNode.getSelfIncrements(otherPhi);
                    }
                    int[] phiIncrement = selfIncrement[phiIndex];
                    int[] otherPhiIncrement = selfIncrement[otherPhiIndex];
                    for (int inputIndex = 0; inputIndex < phiInputCount; ++inputIndex) {
                        if (phiIncrement[inputIndex] == Integer.MIN_VALUE && phi.valueAt(inputIndex) != otherPhi.valueAt(inputIndex) || phiIncrement[inputIndex] != otherPhiIncrement[inputIndex]) continue block1;
                    }
                    if (tool != null) {
                        tool.addToWorkList(otherPhi.usages());
                    }
                    otherPhi.replaceAtUsages(phi);
                    GraphUtil.killWithUnusedFloatingInputs(otherPhi);
                    phis[otherPhiIndex] = null;
                }
            }
        }
    }

    public void markOsrLoop() {
        this.osrLoop = true;
    }

    public boolean isOsrLoop() {
        return this.osrLoop;
    }

    @Override
    protected boolean verifyState() {
        return !this.graph().getGraphState().getFrameStateVerification().implies(GraphState.FrameStateVerificationFeature.LOOP_BEGINS) || super.verifyState();
    }

    @Override
    public void setStateAfter(FrameState x) {
        super.setStateAfter(x);
        if (x != null && this.graph() != null) {
            this.checkDisableCountedBySpeculation(x.bci, this.graph());
        }
    }

    public static enum LoopType {
        SIMPLE_LOOP,
        PRE_LOOP,
        MAIN_LOOP,
        POST_LOOP;

    }
}

