/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.EnumMap;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public class NamedLocationIdentity
extends LocationIdentity
implements JavaKind.FormatWithToString {
    public static final LocationIdentity FINAL_LOCATION = NamedLocationIdentity.immutable("FINAL_LOCATION");
    public static final LocationIdentity ARRAY_LENGTH_LOCATION = NamedLocationIdentity.immutable("[].length");
    public static final LocationIdentity OFF_HEAP_LOCATION = NamedLocationIdentity.mutable("OFF_HEAP_LOCATION");
    private final String name;
    private final boolean immutable;
    private static final EnumMap<JavaKind, LocationIdentity> ARRAY_LOCATIONS = NamedLocationIdentity.initArrayLocations();

    protected NamedLocationIdentity(String name, boolean immutable) {
        this.name = name;
        this.immutable = immutable;
        assert (DB.checkUnique(name));
    }

    public static NamedLocationIdentity mutable(String name) {
        return NamedLocationIdentity.create(name, false);
    }

    public static NamedLocationIdentity immutable(String name) {
        return NamedLocationIdentity.create(name, true);
    }

    private static NamedLocationIdentity create(String name, boolean immutable) {
        return new NamedLocationIdentity(name, immutable);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public String toString() {
        return this.name + (this.isImmutable() ? ":final" : "");
    }

    public static LocationIdentity getArrayLocation(JavaKind elementKind) {
        return ARRAY_LOCATIONS.get(elementKind);
    }

    private static EnumMap<JavaKind, LocationIdentity> initArrayLocations() {
        EnumMap<JavaKind, LocationIdentity> result = new EnumMap<JavaKind, LocationIdentity>(JavaKind.class);
        for (JavaKind kind : JavaKind.values()) {
            result.put(kind, NamedLocationIdentity.mutable("Array: " + kind.getJavaName()));
        }
        return result;
    }

    public static boolean isArrayLocation(LocationIdentity l) {
        return ARRAY_LOCATIONS.containsValue(l);
    }

    static class DB {
        private static final EconomicSet<String> map = EconomicSet.create((Equivalence)Equivalence.DEFAULT);

        DB() {
        }

        static boolean checkUnique(String name) {
            if (!map.add((Object)name)) {
                throw new AssertionError((Object)("identity " + name + " already exists"));
            }
            return true;
        }
    }
}

