/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.function.Function;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.OptimizationLogImpl;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public interface OptimizationLog {
    public static final int MINIMUM_LOG_LEVEL = 4;
    public static final OptimizationEntryDummy OPTIMIZATION_ENTRY_DUMMY = new OptimizationEntryDummy();
    public static final OptimizationLogDummy OPTIMIZATION_LOG_DUMMY = new OptimizationLogDummy();

    public static boolean isOptimizationLogEnabled(OptionValues optionValues) {
        EconomicSet targets = (EconomicSet)DebugOptions.OptimizationLog.getValue(optionValues);
        return targets != null && !targets.isEmpty();
    }

    public boolean isOptimizationLogEnabled();

    public static boolean isAnyLoggingEnabled(DebugContext debugContext) {
        return debugContext.isLogEnabledForMethod() || debugContext.isDumpEnabledForMethod() || DebugOptions.Count.getValue(debugContext.getOptions()) != null || debugContext.hasUnscopedCounters() || OptimizationLog.isOptimizationLogEnabled(debugContext.getOptions());
    }

    public static OptimizationLog getInstance(StructuredGraph graph) {
        if (OptimizationLog.isAnyLoggingEnabled(graph.getDebug())) {
            return new OptimizationLogImpl(graph);
        }
        return OPTIMIZATION_LOG_DUMMY;
    }

    public OptimizationEntry withProperty(String var1, Object var2);

    public <V> OptimizationEntry withLazyProperty(String var1, Supplier<V> var2);

    default public void report(Class<?> optimizationClass, String eventName, Node node) {
        this.report(4, optimizationClass, eventName, node);
    }

    public void report(int var1, Class<?> var2, String var3, Node var4);

    public PartialEscapeLog getPartialEscapeLog();

    public DebugCloseable enterPhase(CharSequence var1);

    public void inline(OptimizationLog var1, boolean var2, NodeSourcePosition var3);

    public void replaceLog(OptimizationLog var1);

    public DebugCloseable enterPartialEscapeAnalysis();

    public void emit(Function<ResolvedJavaMethod, String> var1);

    public static final class OptimizationLogDummy
    implements OptimizationLog {
        private OptimizationLogDummy() {
        }

        @Override
        public DebugCloseable enterPhase(CharSequence name) {
            return null;
        }

        @Override
        public void inline(OptimizationLog calleeOptimizationLog, boolean updatePosition, NodeSourcePosition invokePosition) {
        }

        @Override
        public void replaceLog(OptimizationLog replacementLog) {
        }

        @Override
        public boolean isOptimizationLogEnabled() {
            return false;
        }

        @Override
        public <V> OptimizationEntry withLazyProperty(String key, Supplier<V> valueSupplier) {
            return OPTIMIZATION_ENTRY_DUMMY;
        }

        @Override
        public OptimizationEntry withProperty(String key, Object value) {
            return OPTIMIZATION_ENTRY_DUMMY;
        }

        @Override
        public void report(int logLevel, Class<?> optimizationClass, String eventName, Node node) {
            assert (logLevel >= 4) : logLevel;
        }

        @Override
        public PartialEscapeLog getPartialEscapeLog() {
            return null;
        }

        @Override
        public DebugCloseable enterPartialEscapeAnalysis() {
            return DebugCloseable.VOID_CLOSEABLE;
        }

        @Override
        public void emit(Function<ResolvedJavaMethod, String> methodNameFormatter) {
        }
    }

    public static final class OptimizationEntryDummy
    implements OptimizationEntry {
        private OptimizationEntryDummy() {
        }

        @Override
        public <V> OptimizationEntry withLazyProperty(String key, Supplier<V> valueSupplier) {
            return this;
        }

        @Override
        public OptimizationEntry withProperty(String key, Object value) {
            return this;
        }

        @Override
        public void report(Class<?> optimizationClass, String eventName, Node node) {
        }

        @Override
        public void report(int logLevel, Class<?> optimizationClass, String eventName, Node node) {
            assert (logLevel >= 4) : logLevel;
        }
    }

    public static class PartialEscapeLog {
        private final EconomicMap<VirtualObjectNode, Integer> virtualNodes = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

        public void allocationRemoved(VirtualObjectNode virtualObjectNode) {
            this.virtualNodes.put((Object)virtualObjectNode, (Object)0);
        }

        public void objectMaterialized(VirtualObjectNode virtualObjectNode) {
            Integer count = (Integer)this.virtualNodes.get((Object)virtualObjectNode);
            if (count != null) {
                this.virtualNodes.put((Object)virtualObjectNode, (Object)(count + 1));
            }
        }

        protected EconomicMap<VirtualObjectNode, Integer> getVirtualNodes() {
            return this.virtualNodes;
        }
    }

    public static interface OptimizationEntry {
        public OptimizationEntry withProperty(String var1, Object var2);

        public <V> OptimizationEntry withLazyProperty(String var1, Supplier<V> var2);

        default public void report(Class<?> optimizationClass, String eventName, Node node) {
            this.report(4, optimizationClass, eventName, node);
        }

        public void report(int var1, Class<?> var2, String var3, Node var4);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    public static abstract class OptimizationTreeNode
    extends Node {
        public static final NodeClass<OptimizationTreeNode> TYPE = NodeClass.create(OptimizationTreeNode.class);

        protected OptimizationTreeNode(NodeClass<? extends OptimizationTreeNode> c) {
            super(c);
        }

        abstract EconomicMap<String, Object> asJSONMap(Function<ResolvedJavaMethod, String> var1);
    }
}

