/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.GuardProxyNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryProxyNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Proxy;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class ProxyNode
extends FloatingNode
implements Proxy,
Node.ValueNumberable,
Canonicalizable {
    public static final NodeClass<ProxyNode> TYPE = NodeClass.create(ProxyNode.class);
    @Node.Input(value=InputType.Association)
    LoopExitNode loopExit;

    protected ProxyNode(NodeClass<? extends ProxyNode> c, Stamp stamp, LoopExitNode proxyPoint) {
        super((NodeClass<? extends FloatingNode>)c, stamp);
        assert (proxyPoint != null);
        this.loopExit = proxyPoint;
    }

    public abstract ValueNode value();

    public void setProxyPoint(LoopExitNode newProxyPoint) {
        this.updateUsages(this.loopExit, newProxyPoint);
        this.loopExit = newProxyPoint;
    }

    public LoopExitNode proxyPoint() {
        return this.loopExit;
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.value();
    }

    @Override
    public boolean verify() {
        assert (!(this.value() instanceof ProxyNode) || ((ProxyNode)this.value()).loopExit != this.loopExit) : Assertions.errorMessageContext("this", this, "value", this.value());
        return super.verify();
    }

    public static ValueProxyNode forValue(ValueNode value, LoopExitNode exit) {
        return exit.graph().unique(new ValueProxyNode(value, exit));
    }

    public static GuardProxyNode forGuard(GuardingNode value, LoopExitNode exit) {
        return exit.graph().unique(new GuardProxyNode(value, exit));
    }

    public static MemoryProxyNode forMemory(MemoryKill value, LoopExitNode exit, LocationIdentity locationIdentity) {
        return exit.graph().unique(new MemoryProxyNode(value, exit, locationIdentity));
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.value() == null) {
            return null;
        }
        return this;
    }

    public abstract PhiNode createPhi(AbstractMergeNode var1);

    public abstract ProxyNode duplicateOn(LoopExitNode var1, ValueNode var2);
}

