/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Arrays;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaType;

public class TypeCheckHints {
    private static final Hint[] NO_HINTS = new Hint[0];
    public final ResolvedJavaType exact;
    public final Hint[] hints;
    public final JavaTypeProfile profile;
    public final double hintHitProbability;

    public TypeCheckHints(TypeReference targetType, JavaTypeProfile profile, Assumptions assumptions, double minHintHitProbability, int maxHints) {
        this.profile = profile;
        this.exact = targetType != null && targetType.isExact() ? targetType.getType() : null;
        Double[] hitProbability = new Double[]{null};
        this.hints = TypeCheckHints.makeHints(targetType, profile, minHintHitProbability, maxHints, hitProbability);
        this.hintHitProbability = hitProbability[0];
    }

    private static Hint[] makeHints(TypeReference targetType, JavaTypeProfile profile, double minHintHitProbability, int maxHints, Double[] hitProbability) {
        double hitProb = 0.0;
        Hint[] hintsBuf = NO_HINTS;
        if (profile != null) {
            double notRecordedTypes = profile.getNotRecordedProbability();
            JavaTypeProfile.ProfiledType[] ptypes = profile.getTypes();
            if (notRecordedTypes < 1.0 - minHintHitProbability && ptypes != null && ptypes.length > 0) {
                hintsBuf = new Hint[ptypes.length];
                int hintCount = 0;
                for (JavaTypeProfile.ProfiledType ptype : ptypes) {
                    if (targetType != null) {
                        ResolvedJavaType hintType = ptype.getType();
                        hintsBuf[hintCount++] = new Hint(hintType, targetType.getType().isAssignableFrom(hintType));
                        hitProb += ptype.getProbability();
                    }
                    if (hintCount == maxHints) break;
                }
                if (hitProb >= minHintHitProbability) {
                    if (hintsBuf.length != hintCount || hintCount > maxHints) {
                        hintsBuf = Arrays.copyOf(hintsBuf, Math.min(maxHints, hintCount));
                    }
                } else {
                    hintsBuf = NO_HINTS;
                    hitProb = 0.0;
                }
            }
        }
        hitProbability[0] = hitProb;
        return hintsBuf;
    }

    public static class Hint {
        public final ResolvedJavaType type;
        public final boolean positive;

        Hint(ResolvedJavaType type, boolean positive) {
            this.type = type;
            this.positive = positive;
        }
    }
}

