/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class AbstractNormalizeCompareNode
extends BinaryNode
implements IterableNodeType {
    public static final NodeClass<AbstractNormalizeCompareNode> TYPE = NodeClass.create(AbstractNormalizeCompareNode.class);

    public AbstractNormalizeCompareNode(NodeClass<? extends BinaryNode> c, JavaKind kind, ValueNode x, ValueNode y) {
        super(c, StampFactory.forInteger(kind, -1L, 1L), x, y);
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return this.stamp(NodeView.DEFAULT);
    }

    protected static ValueNode tryConstantFold(ValueNode x, ValueNode y, boolean isUnorderedLess, boolean unsigned, JavaKind kind, ConstantReflectionProvider constantReflection) {
        LogicNode result = CompareNode.tryConstantFold(CanonicalCondition.EQ, x, y, null, false);
        if (result instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)result;
            LogicNode resultLT = CompareNode.tryConstantFold(unsigned ? CanonicalCondition.BT : CanonicalCondition.LT, x, y, constantReflection, isUnorderedLess);
            if (resultLT instanceof LogicConstantNode) {
                LogicConstantNode logicConstantNodeLT = (LogicConstantNode)resultLT;
                if (logicConstantNodeLT.getValue()) {
                    return ConstantNode.forIntegerKind(kind, -1L);
                }
                if (logicConstantNode.getValue()) {
                    return ConstantNode.forIntegerKind(kind, 0L);
                }
                return ConstantNode.forIntegerKind(kind, 1L);
            }
        }
        return null;
    }

    public abstract LogicNode createEqualComparison();

    public abstract LogicNode createEqualComparison(ConstantReflectionProvider var1, MetaAccessProvider var2, OptionValues var3, Integer var4, NodeView var5);

    public LogicNode createLowerComparison() {
        return this.createLowerComparison(false);
    }

    public LogicNode createLowerComparison(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        return this.createLowerComparison(false, constantReflection, metaAccess, options, smallestCompareWidth, view);
    }

    public abstract LogicNode createLowerComparison(boolean var1);

    public abstract LogicNode createLowerComparison(boolean var1, ConstantReflectionProvider var2, MetaAccessProvider var3, OptionValues var4, Integer var5, NodeView var6);
}

