/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.calc.FloatLessThanNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.MinMaxNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_2)
public final class ConditionalNode
extends FloatingNode
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<ConditionalNode> TYPE = NodeClass.create(ConditionalNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode condition;
    @Node.Input(value=InputType.Value)
    ValueNode trueValue;
    @Node.Input(value=InputType.Value)
    ValueNode falseValue;

    public LogicNode condition() {
        return this.condition;
    }

    public ConditionalNode(LogicNode condition) {
        this(condition, ConstantNode.forInt(1, condition.graph()), ConstantNode.forInt(0, condition.graph()));
    }

    public ConditionalNode(LogicNode condition, ValueNode trueValue, ValueNode falseValue) {
        super((NodeClass<? extends FloatingNode>)TYPE, ConditionalNode.combineStamps(condition, trueValue, falseValue, NodeView.DEFAULT));
        assert (trueValue.stamp(NodeView.DEFAULT).isCompatible(falseValue.stamp(NodeView.DEFAULT)));
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public static ValueNode create(LogicNode condition, NodeView view) {
        return ConditionalNode.create(condition, ConstantNode.forInt(1, condition.graph()), ConstantNode.forInt(0, condition.graph()), view);
    }

    public static ValueNode create(LogicNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        ValueNode synonym = ConditionalNode.findSynonym(condition, trueValue, falseValue, view);
        if (synonym != null) {
            return synonym;
        }
        ValueNode result = ConditionalNode.canonicalizeConditional(condition, trueValue, falseValue, ConditionalNode.combineStamps(condition, trueValue, falseValue, view), view, null);
        if (result != null) {
            return result;
        }
        return new ConditionalNode(condition, trueValue, falseValue);
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(ConditionalNode.combineStamps(this.condition, this.trueValue, this.falseValue, NodeView.DEFAULT));
    }

    private static Stamp combineStamps(LogicNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        ValueNode asMinMax = MinMaxNode.fromConditional(condition, trueValue, falseValue, view);
        if (asMinMax != null) {
            return asMinMax.stamp(view);
        }
        return trueValue.stamp(view).meet(falseValue.stamp(view));
    }

    public ValueNode trueValue() {
        return this.trueValue;
    }

    public ValueNode falseValue() {
        return this.falseValue;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        NodeView view = NodeView.from(tool);
        ValueNode synonym = ConditionalNode.findSynonym(this.condition, this.trueValue(), this.falseValue(), view);
        if (synonym != null) {
            return synonym;
        }
        ValueNode result = ConditionalNode.canonicalizeConditional(this.condition, this.trueValue(), this.falseValue(), this.stamp, view, tool);
        if (result != null) {
            return result;
        }
        return this;
    }

    public static ValueNode canonicalizeConditional(LogicNode condition, ValueNode trueValue, ValueNode falseValue, Stamp stamp, NodeView view, CanonicalizerTool canonicalizer) {
        CompareNode lessThan;
        CompareNode compare;
        if (trueValue == falseValue) {
            return trueValue;
        }
        if (condition instanceof CompareNode && ((CompareNode)condition).isIdentityComparison() && ((compare = (CompareNode)condition).getX() == trueValue && compare.getY() == falseValue || compare.getX() == falseValue && compare.getY() == trueValue)) {
            return falseValue;
        }
        if (trueValue.stamp(view) instanceof IntegerStamp) {
            AddNode add;
            IntegerLessThanNode lt;
            if (condition instanceof IntegerLessThanNode) {
                lessThan = (IntegerLessThanNode)condition;
                IntegerStamp falseValueStamp = (IntegerStamp)falseValue.stamp(view);
                IntegerStamp trueValueStamp = (IntegerStamp)trueValue.stamp(view);
                if (lessThan.getX() == trueValue && lessThan.getY() == falseValue ? trueValueStamp.upperBound() <= falseValueStamp.lowerBound() : lessThan.getX() == falseValue && lessThan.getY() == trueValue && falseValueStamp.upperBound() <= trueValueStamp.lowerBound()) {
                    return trueValue;
                }
            }
            if (trueValue.isConstant() && falseValue.isConstant()) {
                long testY;
                IntegerTestNode integerTestNode;
                long constTrueValue = trueValue.asJavaConstant().asLong();
                long constFalseValue = falseValue.asJavaConstant().asLong();
                if (condition instanceof IntegerEqualsNode) {
                    IntegerStamp equalsXStamp;
                    IntegerEqualsNode equals = (IntegerEqualsNode)condition;
                    if (equals.getY().isConstant() && equals.getX().stamp(view) instanceof IntegerStamp && (equalsXStamp = (IntegerStamp)equals.getX().stamp(view)).mayBeSet() == 1L) {
                        long equalsY = equals.getY().asJavaConstant().asLong();
                        if (equalsY == 0L) {
                            if (constTrueValue == 0L && constFalseValue == 1L) {
                                return IntegerConvertNode.convertUnsigned(equals.getX(), stamp, view);
                            }
                            if (constTrueValue == 1L && constFalseValue == 0L) {
                                return IntegerConvertNode.convertUnsigned(XorNode.create(equals.getX(), ConstantNode.forIntegerStamp(equals.getX().stamp(view), 1L), view), stamp, view);
                            }
                        } else if (equalsY == 1L) {
                            if (constTrueValue == 1L && constFalseValue == 0L) {
                                return IntegerConvertNode.convertUnsigned(equals.getX(), stamp, view);
                            }
                            if (constTrueValue == 0L && constFalseValue == 1L) {
                                return IntegerConvertNode.convertUnsigned(XorNode.create(equals.getX(), ConstantNode.forIntegerStamp(equals.getX().stamp(view), 1L), view), stamp, view);
                            }
                        }
                    }
                } else if (condition instanceof IntegerTestNode && (integerTestNode = (IntegerTestNode)condition).getY().isConstant() && integerTestNode.getX().stamp(view) instanceof IntegerStamp && (testY = integerTestNode.getY().asJavaConstant().asLong()) == 1L && constTrueValue == 0L && constFalseValue == 1L) {
                    return IntegerConvertNode.convertUnsigned(AndNode.create(integerTestNode.getX(), integerTestNode.getY(), view), stamp, view);
                }
            }
            if (condition instanceof IntegerLessThanNode && (lt = (IntegerLessThanNode)condition).getY().isDefaultConstant() && falseValue == lt.getX() && trueValue instanceof AddNode && (add = (AddNode)trueValue).getX() == falseValue) {
                int bits = ((IntegerStamp)trueValue.stamp(NodeView.DEFAULT)).getBits();
                RightShiftNode shift = new RightShiftNode(lt.getX(), ConstantNode.forIntegerBits(32, bits - 1));
                AndNode and = new AndNode(shift, add.getY());
                return new AddNode(add.getX(), and);
            }
        }
        if (canonicalizer != null && canonicalizer.supportsRounding() && condition instanceof FloatLessThanNode && trueValue instanceof RoundNode && falseValue instanceof RoundNode) {
            lessThan = (FloatLessThanNode)condition;
            RoundNode trueRound = (RoundNode)trueValue;
            RoundNode falseRound = (RoundNode)falseValue;
            if (trueRound.getValue() == falseRound.getValue()) {
                ValueNode roundInput;
                ValueNode originalRoundInput = roundInput = trueRound.getValue();
                if (roundInput instanceof FloatConvertNode && ((FloatConvertNode)roundInput).op == FloatConvert.F2D) {
                    originalRoundInput = ((FloatConvertNode)roundInput).getValue();
                }
                boolean isTruncate = false;
                if (lessThan.getX() == originalRoundInput && lessThan.getY().isDefaultConstant() && trueRound.mode() == ArithmeticLIRGeneratorTool.RoundingMode.UP && falseRound.mode() == ArithmeticLIRGeneratorTool.RoundingMode.DOWN) {
                    isTruncate = true;
                } else if (lessThan.getX().isDefaultConstant() && lessThan.getY() == originalRoundInput && trueRound.mode() == ArithmeticLIRGeneratorTool.RoundingMode.DOWN && falseRound.mode() == ArithmeticLIRGeneratorTool.RoundingMode.UP) {
                    isTruncate = true;
                }
                if (isTruncate) {
                    return new RoundNode(roundInput, ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE);
                }
            }
        }
        if (condition instanceof IsNullNode && trueValue.isJavaConstant() && trueValue.asJavaConstant().isDefaultForKind() && falseValue == ((IsNullNode)condition).getValue()) {
            return falseValue;
        }
        return null;
    }

    private static ValueNode findSynonym(ValueNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        if (condition instanceof LogicNegationNode) {
            LogicNegationNode negated = (LogicNegationNode)condition;
            return ConditionalNode.create(negated.getValue(), falseValue, trueValue, view);
        }
        if (condition instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)condition;
            if (c.getValue()) {
                return trueValue;
            }
            return falseValue;
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.emitConditional(this);
    }

    public ConditionalNode(StructuredGraph graph, CanonicalCondition condition, ValueNode x, ValueNode y) {
        this(CompareNode.createCompareNode(graph, condition, x, y, null, NodeView.DEFAULT));
    }
}

