/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.TriState;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerTestNode
extends BinaryOpLogicNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerTestNode> TYPE = NodeClass.create(IntegerTestNode.class);

    public IntegerTestNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = IntegerTestNode.canonical(x, y, view);
        if (value != null) {
            return value;
        }
        return new IntegerTestNode(x, y);
    }

    private static LogicNode canonical(ValueNode forX, ValueNode forY, NodeView view) {
        if (forX.isConstant() && forY.isConstant() && forX.isJavaConstant() && forY.isJavaConstant()) {
            return LogicConstantNode.forBoolean((forX.asJavaConstant().asLong() & forY.asJavaConstant().asLong()) == 0L);
        }
        if (forX.stamp(view) instanceof IntegerStamp && forY.stamp(view) instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
            IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
            if ((xStamp.mayBeSet() & yStamp.mayBeSet()) == 0L) {
                return LogicConstantNode.tautology();
            }
            if ((xStamp.mustBeSet() & yStamp.mustBeSet()) != 0L) {
                return LogicConstantNode.contradiction();
            }
            ValueNode newLHS = AndNode.eliminateRedundantBinaryArithmeticOp(forX, yStamp);
            if (newLHS != null) {
                return new IntegerTestNode(newLHS, forY);
            }
            ValueNode newRHS = AndNode.eliminateRedundantBinaryArithmeticOp(forY, xStamp);
            if (newRHS != null) {
                return new IntegerTestNode(forX, newRHS);
            }
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        LogicNode value = IntegerTestNode.canonical(forX, forY, NodeView.from(tool));
        return value != null ? value : this;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        return IntegerTestNode.getSucceedingStamp(negated, xStamp, yStamp);
    }

    private static Stamp getSucceedingStamp(boolean negated, Stamp xStampGeneric, Stamp otherStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && otherStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp otherStamp = (IntegerStamp)otherStampGeneric;
            if (negated) {
                if (Long.bitCount(otherStamp.mayBeSet()) == 1) {
                    long newMustBeSet = xStamp.mustBeSet() | otherStamp.mayBeSet();
                    if (xStamp.mustBeSet() != newMustBeSet) {
                        return IntegerStamp.stampForMask(xStamp.getBits(), newMustBeSet, xStamp.mayBeSet()).join(xStamp);
                    }
                }
            } else {
                long restrictedMayBeSet = (otherStamp.mustBeSet() ^ 0xFFFFFFFFFFFFFFFFL) & xStamp.mayBeSet();
                if (xStamp.mayBeSet() != restrictedMayBeSet) {
                    return IntegerStamp.stampForMask(xStamp.getBits(), xStamp.mustBeSet(), restrictedMayBeSet).join(xStamp);
                }
            }
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        return IntegerTestNode.getSucceedingStamp(negated, yStamp, xStamp);
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
            if ((xStamp.mayBeSet() & yStamp.mayBeSet()) == 0L) {
                return TriState.TRUE;
            }
            if ((xStamp.mustBeSet() & yStamp.mustBeSet()) != 0L) {
                return TriState.FALSE;
            }
        }
        return TriState.UNKNOWN;
    }
}

