/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.MinMaxNode;
import jdk.graal.compiler.nodes.spi.LoweringProvider;

@NodeInfo(shortName="Max")
public class MaxNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.Max> {
    public static final NodeClass<MaxNode> TYPE = NodeClass.create(MaxNode.class);

    protected MaxNode(ValueNode x, ValueNode y) {
        super(TYPE, MaxNode.getArithmeticOpTable(x).getMax(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> getOp(ArithmeticOpTable table) {
        return table.getMax();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMax();
        ConstantNode tryConstantFold = MaxNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new MaxNode(x, y).maybeCommuteInputs();
    }

    @Override
    public ValueNode asConditional(LoweringProvider lowerer) {
        if (!this.stamp(NodeView.DEFAULT).isIntegerStamp()) {
            return null;
        }
        LogicNode condition = IntegerLessThanNode.create(MaxNode.maybeExtendForCompare(this.getX(), lowerer, NumUtil.Signedness.SIGNED), MaxNode.maybeExtendForCompare(this.getY(), lowerer, NumUtil.Signedness.SIGNED), NodeView.DEFAULT);
        return ConditionalNode.create(condition, this.getY(), this.getX(), NodeView.DEFAULT);
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (!super.isNarrowable(resultBits)) {
            return false;
        }
        return super.isNarrowable(resultBits, NumUtil.Signedness.SIGNED);
    }
}

