/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.NarrowableArithmeticNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;

@NodeInfo(shortName="*", cycles=NodeCycles.CYCLES_2)
public class MulNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Mul>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<MulNode> TYPE = NodeClass.create(MulNode.class);

    public MulNode(ValueNode x, ValueNode y) {
        this(TYPE, x, y);
    }

    protected MulNode(NodeClass<? extends MulNode> c, ValueNode x, ValueNode y) {
        super(c, MulNode.getArithmeticOpTable(x).getMul(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Mul> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMul();
        ConstantNode tryConstantFold = MulNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return MulNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Mul> getOp(ArithmeticOpTable table) {
        return table.getMul();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            ValueNode improvement = this.canonical(tool, forY, forX);
            if (improvement != this) {
                return improvement;
            }
            return new MulNode(forY, forX);
        }
        if (forX instanceof NegateNode && forY instanceof NegateNode) {
            return new MulNode(((NegateNode)forX).getValue(), ((NegateNode)forY).getValue()).maybeCommuteInputs();
        }
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Mul> op = this.getOp(forX, forY);
        NodeView view = NodeView.from(tool);
        return MulNode.canonical(this, op, this.stamp(view), forX, forY, view);
    }

    private static ValueNode canonical(MulNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Mul> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (forY.isConstant()) {
            long i;
            ValueNode result;
            ValueNode reassociated;
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (op.isAssociative() && (reassociated = MulNode.reassociateMatchedValues(self != null ? self : (MulNode)new MulNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view)) != self) {
                return reassociated;
            }
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && (result = MulNode.canonical(stamp, forX, i = ((PrimitiveConstant)c).asLong(), view)) != null) {
                return result;
            }
        }
        return self != null ? self : new MulNode(forX, forY).maybeCommuteInputs();
    }

    public static ValueNode canonical(Stamp stamp, ValueNode forX, long i, NodeView view) {
        if (i == 0L) {
            return ConstantNode.forIntegerStamp(stamp, 0L);
        }
        if (i == 1L) {
            return forX;
        }
        if (i == -1L) {
            return NegateNode.create(forX, view);
        }
        if (i > 0L) {
            if (CodeUtil.isPowerOf2((long)i)) {
                return new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)i)));
            }
            if (CodeUtil.isPowerOf2((long)(i - 1L))) {
                return AddNode.create(new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)(i - 1L)))), forX, view);
            }
            if (CodeUtil.isPowerOf2((long)(i + 1L))) {
                return SubNode.create(new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)(i + 1L)))), forX, view);
            }
            int bitCount = Long.bitCount(i);
            long highestBitValue = Long.highestOneBit(i);
            if (bitCount == 2) {
                long lowerBitValue = i - highestBitValue;
                assert (highestBitValue > 0L && lowerBitValue > 0L) : Assertions.errorMessageContext("stamp", stamp, "forX", forX, "i", i, "highestBitVal", highestBitValue, "lowerBitVal", lowerBitValue);
                LeftShiftNode left = new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)highestBitValue)));
                ValueNode right = lowerBitValue == 1L ? forX : new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)lowerBitValue)));
                return AddNode.create(left, right, view);
            }
            int shiftToRoundUpToPowerOf2 = CodeUtil.log2((long)highestBitValue) + 1;
            long subValue = (long)(1 << shiftToRoundUpToPowerOf2) - i;
            if (CodeUtil.isPowerOf2((long)subValue) && shiftToRoundUpToPowerOf2 < ((IntegerStamp)stamp).getBits()) {
                assert (CodeUtil.log2((long)subValue) >= 1) : subValue;
                LeftShiftNode left = new LeftShiftNode(forX, ConstantNode.forInt(shiftToRoundUpToPowerOf2));
                LeftShiftNode right = new LeftShiftNode(forX, ConstantNode.forInt(CodeUtil.log2((long)subValue)));
                return SubNode.create(left, right, view);
            }
        } else if (i < 0L && CodeUtil.isPowerOf2((long)(-i))) {
            return NegateNode.create(LeftShiftNode.create(forX, ConstantNode.forInt(CodeUtil.log2((long)(-i))), view), view);
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value op1 = nodeValueMap.operand(this.getX());
        Value op2 = nodeValueMap.operand(this.getY());
        if (this.shouldSwapInputs(nodeValueMap)) {
            Value tmp = op1;
            op1 = op2;
            op2 = tmp;
        }
        nodeValueMap.setResult(this, gen.emitMul(op1, op2, false));
    }

    protected boolean isExact() {
        return false;
    }
}

