/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class NarrowNode
extends IntegerConvertNode<ArithmeticOpTable.IntegerConvertOp.Narrow> {
    public static final NodeClass<NarrowNode> TYPE = NodeClass.create(NarrowNode.class);

    public NarrowNode(ValueNode input, int resultBits) {
        this(input, PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)), resultBits);
        assert (0 < resultBits && resultBits <= PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT))) : resultBits;
    }

    public NarrowNode(ValueNode input, int inputBits, int resultBits) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getNarrow(), inputBits, resultBits, input);
    }

    public static ValueNode create(ValueNode input, int resultBits, NodeView view) {
        return NarrowNode.create(input, PrimitiveStamp.getBits(input.stamp(view)), resultBits, view);
    }

    public static ValueNode create(ValueNode input, int inputBits, int resultBits, NodeView view) {
        ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> signExtend = ArithmeticOpTable.forStamp(input.stamp(view)).getNarrow();
        ValueNode synonym = NarrowNode.findSynonym(signExtend, input, inputBits, resultBits, signExtend.foldStamp(inputBits, resultBits, input.stamp(view)));
        if (synonym != null) {
            return synonym;
        }
        return new NarrowNode(input, inputBits, resultBits);
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> getOp(ArithmeticOpTable table) {
        return table.getNarrow();
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<?> getReverseOp(ArithmeticOpTable table) {
        assert (this.isSignedLossless() || this.isUnsignedLossless());
        return this.isSignedLossless() ? table.getSignExtend() : table.getZeroExtend();
    }

    @Override
    public boolean isLossless() {
        return this.isSignedLossless() && this.isUnsignedLossless();
    }

    private boolean isSignedLossless() {
        Stamp valueStamp = this.value.stamp(NodeView.DEFAULT);
        int bits = this.getResultBits();
        if (bits > 0 && valueStamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)valueStamp;
            long bitsRangeMin = CodeUtil.minValue((int)bits);
            long bitsRangeMax = CodeUtil.maxValue((int)bits);
            if (bitsRangeMin <= integerStamp.lowerBound() && integerStamp.upperBound() <= bitsRangeMax) {
                return true;
            }
        }
        return false;
    }

    private boolean isUnsignedLossless() {
        long valueMayBeSet;
        IntegerStamp integerStamp;
        Stamp valueStamp = this.value.stamp(NodeView.DEFAULT);
        int bits = this.getResultBits();
        return bits > 0 && valueStamp instanceof IntegerStamp && (integerStamp = (IntegerStamp)valueStamp).isPositive() && ((valueMayBeSet = integerStamp.mayBeSet()) & CodeUtil.mask((int)bits)) == valueMayBeSet;
    }

    @Override
    public boolean preservesOrder(CanonicalCondition cond) {
        switch (cond) {
            case LT: {
                return this.isSignedLossless();
            }
            case EQ: {
                return this.isSignedLossless();
            }
            case BT: {
                return this.isUnsignedLossless();
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported canonical condition.");
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        if (forValue instanceof NarrowNode) {
            NarrowNode other = (NarrowNode)forValue;
            return new NarrowNode(other.getValue(), other.getInputBits(), this.getResultBits());
        }
        if (forValue instanceof IntegerConvertNode) {
            IntegerConvertNode other = (IntegerConvertNode)forValue;
            if (tool.allUsagesAvailable() && (this.graph() == null || this.graph().isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) && other.getValue().hasExactlyOneUsage() && other.hasMoreThanOneUsage()) {
                return this;
            }
            if (this.getResultBits() == other.getInputBits()) {
                return other.getValue();
            }
            if (this.getResultBits() < other.getInputBits()) {
                return new NarrowNode(other.getValue(), other.getInputBits(), this.getResultBits());
            }
            if (other instanceof SignExtendNode) {
                return SignExtendNode.create(other.getValue(), other.getInputBits(), this.getResultBits(), view);
            }
            if (other instanceof ZeroExtendNode) {
                return new ZeroExtendNode(other.getValue(), other.getInputBits(), this.getResultBits(), ((ZeroExtendNode)other).isInputAlwaysPositive());
            }
        } else if (forValue instanceof AndNode) {
            AndNode andNode = (AndNode)forValue;
            Stamp xStamp = andNode.getX().stamp(view);
            Stamp yStamp = andNode.getY().stamp(view);
            if (xStamp instanceof IntegerStamp && yStamp instanceof IntegerStamp) {
                long relevantMask = CodeUtil.mask((int)this.getResultBits());
                if ((relevantMask & ((IntegerStamp)yStamp).mustBeSet()) == relevantMask) {
                    return NarrowNode.create(andNode.getX(), this.getResultBits(), view);
                }
                if ((relevantMask & ((IntegerStamp)xStamp).mustBeSet()) == relevantMask) {
                    return NarrowNode.create(andNode.getY(), this.getResultBits(), view);
                }
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitNarrow(nodeValueMap.operand(this.getValue()), this.getResultBits()));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }
}

