/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.PointerEqualsNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.VirtualBoxingNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(shortName="==")
public final class ObjectEqualsNode
extends PointerEqualsNode
implements Virtualizable {
    public static final NodeClass<ObjectEqualsNode> TYPE = NodeClass.create(ObjectEqualsNode.class);
    private static final ObjectEqualsOp OP = new ObjectEqualsOp();

    public ObjectEqualsNode(ValueNode x, ValueNode y) {
        super((NodeClass<? extends PointerEqualsNode>)TYPE, x, y);
        assert (x.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp && y.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp) : Assertions.errorMessageContext("x", x, "y", y);
    }

    public static LogicNode create(ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode result = ObjectEqualsNode.tryConstantFold(CanonicalCondition.EQ, x, y, constantReflection, false);
        if (result != null) {
            return result;
        }
        result = ObjectEqualsNode.findSynonym(x, y, view);
        if (result != null) {
            return result;
        }
        return new ObjectEqualsNode(x, y);
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = OP.canonical(constantReflection, metaAccess, options, null, CanonicalCondition.EQ, false, x, y, view);
        if (result != null) {
            return result;
        }
        return ObjectEqualsNode.create(x, y, constantReflection, view);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    private static LogicNode virtualizeNonVirtualComparison(VirtualObjectNode virtual, ValueNode other, StructuredGraph graph, VirtualizerTool tool) {
        VirtualBoxingNode virtualBoxingNode;
        if (virtual instanceof VirtualBoxingNode && other.isConstant() && (virtualBoxingNode = (VirtualBoxingNode)virtual).getBoxingKind() == JavaKind.Boolean) {
            JavaConstant otherUnboxed = tool.getConstantReflection().unboxPrimitive(other.asJavaConstant());
            if (otherUnboxed != null && otherUnboxed.getJavaKind() == JavaKind.Boolean) {
                int expectedValue = otherUnboxed.asBoolean() ? 1 : 0;
                return new IntegerEqualsNode(virtualBoxingNode.getBoxedValue(tool), ConstantNode.forInt(expectedValue, graph));
            }
            return LogicConstantNode.contradiction(graph);
        }
        if (virtual.hasIdentity()) {
            return LogicConstantNode.contradiction(graph);
        }
        return null;
    }

    public static LogicNode virtualizeComparison(ValueNode x, ValueNode y, StructuredGraph graph, VirtualizerTool tool) {
        VirtualObjectNode yVirtual;
        ValueNode xAlias = tool.getAlias(x);
        ValueNode yAlias = tool.getAlias(y);
        VirtualObjectNode xVirtual = xAlias instanceof VirtualObjectNode ? (VirtualObjectNode)xAlias : null;
        VirtualObjectNode virtualObjectNode = yVirtual = yAlias instanceof VirtualObjectNode ? (VirtualObjectNode)yAlias : null;
        if (xVirtual != null && yVirtual == null) {
            return ObjectEqualsNode.virtualizeNonVirtualComparison(xVirtual, yAlias, graph, tool);
        }
        if (xVirtual == null && yVirtual != null) {
            return ObjectEqualsNode.virtualizeNonVirtualComparison(yVirtual, xAlias, graph, tool);
        }
        if (xVirtual != null && yVirtual != null) {
            if (xVirtual.hasIdentity() ^ yVirtual.hasIdentity()) {
                return LogicConstantNode.contradiction(graph);
            }
            if (!xVirtual.hasIdentity() && !yVirtual.hasIdentity()) {
                MetaAccessProvider metaAccess;
                ResolvedJavaType type = xVirtual.type();
                if (type.equals((Object)yVirtual.type()) && (type.equals((Object)(metaAccess = tool.getMetaAccess()).lookupJavaType(Integer.class)) || type.equals((Object)metaAccess.lookupJavaType(Long.class)))) {
                    assert (xVirtual.entryCount() == 1 && yVirtual.entryCount() == 1) : Assertions.errorMessageContext("x", xVirtual, "y", yVirtual);
                    assert (xVirtual.entryKind(tool.getMetaAccessExtensionProvider(), 0).getStackKind() == JavaKind.Int || xVirtual.entryKind(tool.getMetaAccessExtensionProvider(), 0) == JavaKind.Long) : Assertions.errorMessage(x, y, xVirtual);
                    return new IntegerEqualsNode(tool.getEntry(xVirtual, 0), tool.getEntry(yVirtual, 0));
                }
            } else {
                return LogicConstantNode.forBoolean(xVirtual == yVirtual, graph);
            }
        }
        return null;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        LogicNode node = ObjectEqualsNode.virtualizeComparison(this.getX(), this.getY(), this.graph(), tool);
        if (node == null) {
            return;
        }
        tool.ensureAdded(node);
        tool.replaceWithValue(node);
    }

    public static class ObjectEqualsOp
    extends PointerEqualsNode.PointerEqualsOp {
        @Override
        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            ResolvedJavaType type = constantReflection.asJavaType(constant);
            if (type != null && nonConstant instanceof GetClassNode) {
                GetClassNode getClassNode = (GetClassNode)nonConstant;
                ValueNode object = getClassNode.getObject();
                assert (((ObjectStamp)object.stamp(view)).nonNull());
                if (!type.isPrimitive() && (type.isConcrete() || type.isArray())) {
                    return InstanceOfNode.create(TypeReference.createExactTrusted(type), object);
                }
                return LogicConstantNode.forBoolean(false);
            }
            if (nonConstant instanceof AbstractNewObjectNode || nonConstant instanceof AllocatedObjectNode) {
                assert (!(nonConstant instanceof BoxNode)) : Assertions.errorMessageContext("nonConstant", nonConstant);
                return LogicConstantNode.forBoolean(false);
            }
            return super.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, constant, nonConstant, mirrored, unorderedIsTrue, view);
        }

        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof ObjectStamp && newY.stamp(view) instanceof ObjectStamp) {
                return new ObjectEqualsNode(newX, newY);
            }
            if (newX.stamp(view) instanceof AbstractPointerStamp && newY.stamp(view) instanceof AbstractPointerStamp) {
                return new PointerEqualsNode(newX, newY);
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(String.valueOf(newX.stamp(view)) + " " + String.valueOf(newY.stamp(view)));
        }
    }
}

