/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class RoundFloatToIntegerNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<RoundFloatToIntegerNode> TYPE = NodeClass.create(RoundFloatToIntegerNode.class);

    public RoundFloatToIntegerNode(ValueNode value) {
        super(TYPE, RoundFloatToIntegerNode.roundStamp((FloatStamp)value.stamp(NodeView.DEFAULT)), value);
    }

    private static IntegerStamp roundStamp(FloatStamp stamp) {
        double min = stamp.lowerBound();
        double max = stamp.upperBound();
        if (stamp.getBits() == 32) {
            long lowerBound = Math.round((float)min);
            long upperBound = Math.round((float)max);
            IntegerStamp newStamp = IntegerStamp.create(32, lowerBound, upperBound);
            if (stamp.canBeNaN()) {
                return (IntegerStamp)newStamp.meet(IntegerStamp.create(32, 0L, 0L));
            }
            return newStamp;
        }
        assert (stamp.getBits() == 64) : Assertions.errorMessageContext("stamp", stamp);
        long lowerBound = Math.round(min);
        long upperBound = Math.round(max);
        IntegerStamp newStamp = IntegerStamp.create(64, lowerBound, upperBound);
        if (stamp.canBeNaN()) {
            return (IntegerStamp)newStamp.meet(IntegerStamp.create(64, 0L, 0L));
        }
        return newStamp;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return RoundFloatToIntegerNode.roundStamp((FloatStamp)newStamp);
    }

    private static ValueNode tryFold(ValueNode input) {
        if (input.isConstant()) {
            JavaConstant c = input.asJavaConstant();
            if (c.getJavaKind() == JavaKind.Double) {
                return ConstantNode.forLong(Math.round(c.asDouble()));
            }
            if (c.getJavaKind() == JavaKind.Float) {
                return ConstantNode.forInt(Math.round(c.asFloat()));
            }
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = RoundFloatToIntegerNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitRoundFloatToInteger(builder.operand(this.getValue())));
    }
}

