/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class SignumNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<SignumNode> TYPE = NodeClass.create(SignumNode.class);

    public SignumNode(ValueNode x) {
        super(TYPE, SignumNode.computeStamp(x.stamp(NodeView.DEFAULT)), x);
    }

    private static Stamp computeStamp(Stamp stamp) {
        FloatStamp floatStamp = (FloatStamp)stamp;
        if (floatStamp.isNaN()) {
            return floatStamp;
        }
        if (floatStamp.isNonNaN()) {
            if (floatStamp.lowerBound() > 0.0) {
                return new FloatStamp(floatStamp.getBits(), 1.0, 1.0, true);
            }
            if (floatStamp.upperBound() < 0.0) {
                return new FloatStamp(floatStamp.getBits(), -1.0, -1.0, true);
            }
        }
        FloatStamp result = new FloatStamp(floatStamp.getBits(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, floatStamp.isNonNaN());
        if (floatStamp.contains(0.0)) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), 0.0, 0.0, true));
        }
        if (floatStamp.upperBound() > 0.0) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), 1.0, 1.0, true));
        }
        if (floatStamp.lowerBound() < 0.0) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), -1.0, -1.0, true));
        }
        return result;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return SignumNode.computeStamp(newStamp);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isJavaConstant()) {
            JavaConstant c = forValue.asJavaConstant();
            switch (c.getJavaKind()) {
                case Float: {
                    return ConstantNode.forFloat(Math.signum(c.asFloat()));
                }
                case Double: {
                    return ConstantNode.forDouble(Math.signum(c.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(c.getJavaKind());
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathSignum(nodeValueMap.operand(this.getValue())));
    }
}

