/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(shortName=">>>")
public final class UnsignedRightShiftNode
extends ShiftNode<ArithmeticOpTable.ShiftOp.UShr> {
    public static final NodeClass<UnsignedRightShiftNode> TYPE = NodeClass.create(UnsignedRightShiftNode.class);

    public UnsignedRightShiftNode(ValueNode x, ValueNode y) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getUShr(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.UShr> op = ArithmeticOpTable.forStamp(x.stamp(view)).getUShr();
        ValueNode value = ShiftNode.canonical(op, stamp = op.foldStamp(x.stamp(view), (IntegerStamp)y.stamp(view)), x, y, view);
        if (value != null) {
            return value;
        }
        return UnsignedRightShiftNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.UShr> getOp(ArithmeticOpTable table) {
        return table.getUShr();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return UnsignedRightShiftNode.canonical(this, (ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.UShr>)this.getArithmeticOp(), this.stamp(view), forX, forY, view);
    }

    private static ValueNode canonical(UnsignedRightShiftNode node, ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.UShr> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (forY.isConstant()) {
            ShiftNode other;
            int amount;
            int originalAmout = amount = forY.asJavaConstant().asInt();
            int mask = op.getShiftAmountMask(stamp);
            if ((amount &= mask) == 0) {
                return forX;
            }
            Stamp xStampGeneric = forX.stamp(view);
            if (xStampGeneric instanceof IntegerStamp) {
                long xUpperBound;
                IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
                long xMask = CodeUtil.mask((int)xStamp.getBits());
                long xLowerBound = xStamp.lowerBound() & xMask;
                if (xLowerBound >>> amount == (xUpperBound = xStamp.upperBound() & xMask) >>> amount) {
                    return ConstantNode.forIntegerKind(stamp.getStackKind(), xLowerBound >>> amount);
                }
                if (amount == xStamp.getBits() - 1 && xStamp.lowerBound() == -1L && xStamp.upperBound() == 0L) {
                    return NegateNode.create(forX, view);
                }
            }
            if (forX instanceof ShiftNode && (other = (ShiftNode)forX).getY().isConstant()) {
                int otherAmount = other.getY().asJavaConstant().asInt() & mask;
                if (other instanceof UnsignedRightShiftNode) {
                    int total = amount + otherAmount;
                    if (total != (total & mask)) {
                        return ConstantNode.forIntegerKind(stamp.getStackKind(), 0L);
                    }
                    return new UnsignedRightShiftNode(other.getX(), ConstantNode.forInt(total));
                }
                if (other instanceof LeftShiftNode && otherAmount == amount) {
                    if (stamp.getStackKind() == JavaKind.Long) {
                        return new AndNode(other.getX(), ConstantNode.forLong(-1L >>> amount));
                    }
                    assert (stamp.getStackKind() == JavaKind.Int) : Assertions.errorMessage(node, op, stamp, forX, forY);
                    return new AndNode(other.getX(), ConstantNode.forInt(-1 >>> amount));
                }
            }
            if (originalAmout != amount) {
                return new UnsignedRightShiftNode(forX, ConstantNode.forInt(amount));
            }
        }
        if (node != null) {
            return node;
        }
        return new UnsignedRightShiftNode(forX, forY);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitUShr(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (resultBits >= 32 && super.isNarrowable(resultBits)) {
            IntegerStamp inputStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            return (inputStamp.mayBeSet() & (CodeUtil.mask((int)resultBits) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
        }
        return false;
    }
}

