/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class ZeroExtendNode
extends IntegerConvertNode<ArithmeticOpTable.IntegerConvertOp.ZeroExtend> {
    public static final NodeClass<ZeroExtendNode> TYPE = NodeClass.create(ZeroExtendNode.class);
    private final boolean inputAlwaysPositive;

    public ZeroExtendNode(ValueNode input, int resultBits) {
        this(input, PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)), resultBits, false);
        assert (0 < PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) && PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) <= resultBits) : Assertions.errorMessageContext("input", input, "resultBits", resultBits);
    }

    public ZeroExtendNode(ValueNode input, int inputBits, int resultBits, boolean inputAlwaysPositive) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getZeroExtend(), inputBits, resultBits, input);
        this.inputAlwaysPositive = inputAlwaysPositive;
        GraalError.guarantee(!inputAlwaysPositive, "ZeroExtendNode.inputAlwaysPositive is deprecated.");
    }

    public static ValueNode create(ValueNode input, int resultBits, NodeView view) {
        return ZeroExtendNode.create(input, PrimitiveStamp.getBits(input.stamp(view)), resultBits, view, false);
    }

    public static ValueNode create(ValueNode input, int inputBits, int resultBits, NodeView view) {
        return ZeroExtendNode.create(input, inputBits, resultBits, view, false);
    }

    public static ValueNode create(ValueNode input, int inputBits, int resultBits, NodeView view, boolean alwaysPositive) {
        ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.ZeroExtend> signExtend = ArithmeticOpTable.forStamp(input.stamp(view)).getZeroExtend();
        ValueNode synonym = ZeroExtendNode.findSynonym(signExtend, input, inputBits, resultBits, signExtend.foldStamp(inputBits, resultBits, input.stamp(view)));
        if (synonym != null) {
            return synonym;
        }
        return ZeroExtendNode.canonical(null, input, inputBits, resultBits, view, alwaysPositive);
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.ZeroExtend> getOp(ArithmeticOpTable table) {
        return table.getZeroExtend();
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> getReverseOp(ArithmeticOpTable table) {
        return table.getNarrow();
    }

    @Override
    public boolean isLossless() {
        return true;
    }

    public boolean isInputAlwaysPositive() {
        return this.inputAlwaysPositive;
    }

    @Override
    public boolean preservesOrder(CanonicalCondition cond) {
        switch (cond) {
            case LT: {
                return false;
            }
        }
        return true;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        return ZeroExtendNode.canonical(this, forValue, this.getInputBits(), this.getResultBits(), view, this.inputAlwaysPositive);
    }

    private static ValueNode canonical(ZeroExtendNode zeroExtendNode, ValueNode forValue, int inputBits, int resultBits, NodeView view, boolean alwaysPositive) {
        NarrowNode narrow;
        Stamp inputStamp;
        ZeroExtendNode self = zeroExtendNode;
        if (forValue instanceof ZeroExtendNode) {
            ZeroExtendNode other = (ZeroExtendNode)forValue;
            return new ZeroExtendNode(other.getValue(), other.getInputBits(), resultBits, other.isInputAlwaysPositive());
        }
        if (forValue instanceof NarrowNode && (inputStamp = (narrow = (NarrowNode)forValue).getValue().stamp(view)) instanceof IntegerStamp) {
            IntegerStamp istamp = (IntegerStamp)inputStamp;
            long mask = CodeUtil.mask((int)PrimitiveStamp.getBits(narrow.stamp(view)));
            if ((istamp.mayBeSet() & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                if (istamp.getBits() < resultBits) {
                    return ZeroExtendNode.create(narrow.getValue(), resultBits, view);
                }
                if (istamp.getBits() > resultBits) {
                    return NarrowNode.create(narrow.getValue(), resultBits, view);
                }
                assert (istamp.getBits() == resultBits) : Assertions.errorMessageContext("zeroExtend", zeroExtendNode, "forVal", forValue, "inputBits", inputBits, "resultBits", resultBits, "alwaysPositive", alwaysPositive);
                return narrow.getValue();
            }
        }
        if (self == null) {
            self = new ZeroExtendNode(forValue, inputBits, resultBits, alwaysPositive);
        }
        return self;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitZeroExtend(nodeValueMap.operand(this.getValue()), this.getInputBits(), this.getResultBits()));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return true;
    }
}

