/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;

public class ControlFlowGraphBuilder {
    private final StructuredGraph structuredGraph;
    private boolean backendBlocks;
    private boolean connectBlocks;
    private boolean computeFrequency;
    private boolean computeLoops;
    private boolean computeDominators;
    private boolean computePostdominators;

    public ControlFlowGraphBuilder(StructuredGraph structuredGraph) {
        this.structuredGraph = structuredGraph;
    }

    public ControlFlowGraphBuilder backendBlocks(boolean backendBlocks) {
        this.backendBlocks = backendBlocks;
        return this;
    }

    public ControlFlowGraphBuilder connectBlocks(boolean connectBlocks) {
        this.connectBlocks = connectBlocks;
        return this;
    }

    public ControlFlowGraphBuilder computeFrequency(boolean computeFrequency) {
        this.computeFrequency = computeFrequency;
        return this;
    }

    public ControlFlowGraphBuilder computeLoops(boolean computeLoops) {
        this.computeLoops = computeLoops;
        return this;
    }

    public ControlFlowGraphBuilder computeDominators(boolean computeDominators) {
        this.computeDominators = computeDominators;
        return this;
    }

    public ControlFlowGraphBuilder computePostdominators(boolean computePostdominators) {
        this.computePostdominators = computePostdominators;
        return this;
    }

    public ControlFlowGraph build() {
        return ControlFlowGraph.compute(this.structuredGraph, this.backendBlocks, this.connectBlocks, this.computeFrequency, this.computeLoops, this.computeDominators, this.computePostdominators);
    }
}

