/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.cfg.LocationSet;
import org.graalvm.word.LocationIdentity;

public final class HIRLoop
extends Loop<HIRBlock> {
    private LocationSet killLocations;

    protected HIRLoop(Loop<HIRBlock> parent, int index, HIRBlock header) {
        super(parent, index, header);
    }

    @Override
    public int numBackedges() {
        return ((LoopBeginNode)((HIRBlock)this.getHeader()).getBeginNode()).loopEnds().count();
    }

    public LocationSet getKillLocations() {
        if (this.killLocations == null) {
            this.killLocations = new LocationSet();
            for (HIRBlock b : this.getBlocks()) {
                if (b.getLoop() != this) continue;
                this.killLocations.addAll(b.getKillLocations());
                if (!this.killLocations.isAny()) continue;
                break;
            }
        }
        for (Loop child : this.getChildren()) {
            if (this.killLocations.isAny()) break;
            this.killLocations.addAll(((HIRLoop)child).getKillLocations());
        }
        return this.killLocations;
    }

    public boolean canKill(LocationIdentity location) {
        return this.getKillLocations().contains(location);
    }

    @Override
    public String toString() {
        return super.toString() + " header:" + String.valueOf(((HIRBlock)this.getHeader()).getBeginNode());
    }
}

