/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.cfg;

import java.util.List;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.LinkedStack;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;

public class ReversePostOrder {
    private static void enqueueBlockInRPO(HIRBlock b, HIRBlock[] reversePostOrder, int nextIndex) {
        reversePostOrder[nextIndex] = b;
        b.setId(nextIndex);
    }

    private static void compute(ControlFlowGraph cfg, FixedNode start, HIRBlock[] rpoBlocks, int startIndex) {
        assert (startIndex < rpoBlocks.length) : Assertions.errorMessageContext("startIndex", startIndex, "blockLength", rpoBlocks.length);
        LinkedStack<Node> toProcess = new LinkedStack<Node>();
        toProcess.push(start);
        NodeBitMap visitedNodes = cfg.graph.createNodeBitMap();
        int currentIndex = startIndex;
        class OpenLoopsData {
            int endsVisited;
            final LoopBeginNode lb;
            final /* synthetic */ NodeBitMap val$visitedNodes;

            OpenLoopsData(LoopBeginNode loopBeginNode) {
                this.val$visitedNodes = loopBeginNode;
                this.lb = lb;
            }

            boolean loopHasNoExits() {
                return this.lb.loopExits().count() == 0;
            }

            boolean loopFullyProcessed() {
                return this.allEndsVisited() && this.allLexPredecessorsVisited();
            }

            boolean allEndsVisited() {
                return this.lb.getLoopEndCount() == this.endsVisited;
            }

            boolean allLexPredecessorsVisited() {
                for (LoopExitNode lex : this.lb.loopExits()) {
                    FixedNode pred = (FixedNode)lex.predecessor();
                    if (this.val$visitedNodes.isMarked(pred)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return String.valueOf(this.lb) + "-> ends visited=" + this.endsVisited;
            }
        }
        LinkedStack<OpenLoopsData> openLoops = new LinkedStack<OpenLoopsData>();
        block0: while (true) {
            int i;
            OpenLoopsData olPeek;
            CompilationAlarm.checkProgress(cfg.graph);
            FixedNode cur = null;
            if (!openLoops.isEmpty() && (olPeek = (OpenLoopsData)openLoops.peek()).loopFullyProcessed()) {
                cur = olPeek.lb.loopExits().first();
            }
            if (cur == null && !toProcess.isEmpty()) {
                cur = (FixedNode)toProcess.pop();
            }
            if (cur == null) break;
            if (cur instanceof LoopBeginNode) {
                openLoops.push(new OpenLoopsData((LoopBeginNode)cur, visitedNodes));
            }
            if (cur instanceof LoopExitNode) {
                LoopExitNode lex = (LoopExitNode)cur;
                OpenLoopsData ol = (OpenLoopsData)openLoops.peek();
                GraalError.guarantee(ol.lb == lex.loopBegin(), "Different loop on stack, should be %s is %s", (Object)lex.loopBegin(), (Object)ol.lb);
                GraalError.guarantee(ol != null, "No open loop for loop exit %s with loop begin %s", (Object)lex, (Object)lex.loopBegin());
                if (!ol.loopFullyProcessed()) {
                    GraalError.guarantee(!toProcess.isEmpty(), "If a loop is not fully processed there need to be further blocks, %s", (Object)lex);
                    continue;
                }
                openLoops.pop();
                List<LoopExitNode> loopExits = ol.lb.loopExits().snapshot();
                i = loopExits.size() - 1;
                while (true) {
                    if (i < 0) continue block0;
                    LoopExitNode singleExit = loopExits.get(i);
                    ReversePostOrder.enqueueBlockInRPO(cfg.blockFor(singleExit), rpoBlocks, currentIndex++);
                    visitedNodes.mark(singleExit);
                    ReversePostOrder.pushOrStall(singleExit.next(), toProcess);
                    --i;
                }
            }
            HIRBlock curBlock = cfg.blockFor(cur);
            if (cur == curBlock.getBeginNode()) {
                ReversePostOrder.enqueueBlockInRPO(curBlock, rpoBlocks, currentIndex++);
            }
            while (true) {
                CompilationAlarm.checkProgress(cfg.graph);
                visitedNodes.mark(cur);
                if (cur == curBlock.getEndNode()) {
                    if (cur instanceof EndNode) {
                        EndNode endNode = (EndNode)cur;
                        if (!ReversePostOrder.allEndsVisited(visitedNodes, endNode)) continue block0;
                        ReversePostOrder.pushOrStall(endNode.merge(), toProcess);
                        continue block0;
                    }
                    if (cur instanceof LoopEndNode) {
                        LoopEndNode len = (LoopEndNode)cur;
                        OpenLoopsData ol = (OpenLoopsData)openLoops.peek();
                        GraalError.guarantee(ol.lb == len.loopBegin(), "Loop begin does not match, loop end begin %s stack loop begin %s", (Object)len.loopBegin(), (Object)ol.lb);
                        ++ol.endsVisited;
                        if (!ol.loopHasNoExits() || !ol.loopFullyProcessed()) continue block0;
                        openLoops.pop();
                        continue block0;
                    }
                    if (cur instanceof ControlSplitNode) {
                        ControlSplitNode split = (ControlSplitNode)cur;
                        List<Node> successors = split.successors().snapshot();
                        i = successors.size() - 1;
                        while (true) {
                            if (i < 0) continue block0;
                            FixedNode successor = (FixedNode)successors.get(i);
                            ReversePostOrder.pushOrStall(successor, toProcess);
                            --i;
                        }
                    }
                    if (cur instanceof FixedWithNextNode) {
                        ReversePostOrder.pushOrStall(((FixedWithNextNode)cur).next(), toProcess);
                        continue block0;
                    }
                    GraalError.guarantee(cur instanceof ControlSinkNode, "Node %s must be a control flow sink", (Object)cur);
                    continue block0;
                }
                cur = ((FixedWithNextNode)cur).next();
            }
            break;
        }
    }

    private static void pushOrStall(FixedNode n, LinkedStack<Node> toProcess) {
        if (!(n instanceof LoopExitNode)) {
            toProcess.push(n);
        }
    }

    private static boolean allEndsVisited(NodeBitMap stalledEnds, AbstractEndNode current) {
        for (AbstractEndNode abstractEndNode : current.merge().forwardEnds()) {
            if (abstractEndNode == current || stalledEnds.isMarked(abstractEndNode)) continue;
            return false;
        }
        return true;
    }

    public static HIRBlock[] identifyBlocks(ControlFlowGraph cfg, int numBlocks) {
        HIRBlock[] reversePostOrder = new HIRBlock[numBlocks];
        ReversePostOrder.compute(cfg, cfg.graph.start(), reversePostOrder, 0);
        if (reversePostOrder[0].isModifiable()) {
            HIRBlock.assignPredecessorsAndSuccessors(reversePostOrder, cfg);
        }
        return reversePostOrder;
    }
}

