/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.debug;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Memory})
public class SideEffectNode
extends AbstractMemoryCheckpoint
implements LIRLowerable,
SingleMemoryKill {
    public static final NodeClass<SideEffectNode> TYPE = NodeClass.create(SideEffectNode.class);
    @Node.OptionalInput
    ValueNode value;

    public SideEffectNode() {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forVoid());
    }

    public SideEffectNode(ValueNode value) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (this.value != null) {
            generator.setResult(this, generator.operand(this.value));
        }
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public ValueNode getValue() {
        return this.value;
    }
}

