/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class AbstractBoxingNode
extends FixedWithNextNode
implements Virtualizable,
Lowerable,
Canonicalizable.Unary<ValueNode>,
MemoryAccess {
    public static final NodeClass<AbstractBoxingNode> TYPE = NodeClass.create(AbstractBoxingNode.class);
    @Node.Input
    protected ValueNode value;
    protected final JavaKind boxingKind;
    protected final LocationIdentity accessedLocation;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;

    public AbstractBoxingNode(NodeClass<? extends AbstractBoxingNode> c, ValueNode value, JavaKind boxingKind, Stamp s, LocationIdentity accessedLocation) {
        super((NodeClass<? extends FixedWithNextNode>)c, s);
        this.value = value;
        this.boxingKind = boxingKind;
        this.accessedLocation = accessedLocation;
    }

    public static ResolvedJavaField getValueField(ResolvedJavaType resultType) {
        for (ResolvedJavaField f : resultType.getInstanceFields(false)) {
            if (!f.getName().equals("value")) continue;
            return f;
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(resultType);
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public JavaKind getBoxingKind() {
        return this.boxingKind;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsagesInterface(this.lastLocationAccess, newlla);
        this.lastLocationAccess = newlla;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.accessedLocation;
    }
}

