/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.util.Collections;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizableAllocation;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.VirtualBoxingNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_16, allowedUsageTypes={InputType.Value})
public abstract class BoxNode
extends AbstractBoxingNode
implements IterableNodeType,
VirtualizableAllocation,
Lowerable,
Canonicalizable.Unary<ValueNode>,
Node.IndirectCanonicalization {
    public static final NodeClass<BoxNode> TYPE = NodeClass.create(BoxNode.class);
    private boolean hasIdentity;

    private BoxNode(NodeClass<? extends BoxNode> c, ValueNode value, ResolvedJavaType resultType, JavaKind boxingKind) {
        super(c, value, boxingKind, StampFactory.objectNonNull(TypeReference.createExactTrusted(resultType)), new FieldLocationIdentity(BoxNode.getValueField(resultType)));
        this.value = value;
    }

    private BoxNode(NodeClass<? extends BoxNode> c, ValueNode value, JavaKind boxingKind, Stamp s, LocationIdentity accessedLocation) {
        super(c, value, boxingKind, s, accessedLocation);
        this.value = value;
    }

    public static BoxNode create(ValueNode value, ResolvedJavaType resultType, JavaKind boxingKind) {
        if (boxingKind == JavaKind.Boolean) {
            return new PureBoxNode(value, resultType, boxingKind);
        }
        return new AllocatingBoxNode(value, resultType, boxingKind);
    }

    public boolean hasIdentity() {
        return this.hasIdentity;
    }

    public void setHasIdentity() {
        assert (!(this.getValue() instanceof TrustedBoxedValue)) : String.valueOf(this) + ": " + String.valueOf(this.getValue());
        this.hasIdentity = true;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        UnboxNode unbox;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (forValue instanceof UnboxNode && (unbox = (UnboxNode)forValue).getBoxingKind() == this.getBoxingKind()) {
            ValueNode unboxInput = unbox.getValue();
            if (unboxInput instanceof BoxNode && ((BoxNode)unboxInput).getBoxingKind() == this.getBoxingKind()) {
                return unboxInput;
            }
            if (unboxInput instanceof TrustedBoxedValue) {
                return ((TrustedBoxedValue)unboxInput).getValue();
            }
        }
        return this;
    }

    protected VirtualBoxingNode createVirtualBoxingNode() {
        VirtualBoxingNode node = new VirtualBoxingNode(StampTool.typeOrNull(this.stamp(NodeView.DEFAULT)), this.boxingKind);
        return node;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        if (this.hasIdentity) {
            return;
        }
        ValueNode alias = tool.getAlias(this.getValue());
        VirtualBoxingNode newVirtual = this.createVirtualBoxingNode();
        assert (newVirtual.getFields().length == 1) : Assertions.errorMessage(this, newVirtual);
        tool.createVirtualObject(newVirtual, new ValueNode[]{alias}, Collections.emptyList(), this.getNodeSourcePosition(), false);
        tool.replaceWithVirtual(newVirtual);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Value})
    private static class PureBoxNode
    extends BoxNode {
        public static final NodeClass<PureBoxNode> TYPE = NodeClass.create(PureBoxNode.class);

        protected PureBoxNode(ValueNode value, ResolvedJavaType resultType, JavaKind boxingKind) {
            super(TYPE, value, resultType, boxingKind);
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory, InputType.Value})
    private static class AllocatingBoxNode
    extends BoxNode
    implements SingleMemoryKill {
        public static final NodeClass<AllocatingBoxNode> TYPE = NodeClass.create(AllocatingBoxNode.class);

        protected AllocatingBoxNode(ValueNode value, ResolvedJavaType resultType, JavaKind boxingKind) {
            super(TYPE, value, resultType, boxingKind);
        }

        @Override
        public LocationIdentity getLocationIdentity() {
            return LocationIdentity.INIT_LOCATION;
        }

        @Override
        public LocationIdentity getKilledLocationIdentity() {
            return this.getLocationIdentity();
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    public static class TrustedBoxedValue
    extends FloatingNode
    implements Canonicalizable,
    Virtualizable,
    Lowerable {
        public static final NodeClass<TrustedBoxedValue> TYPE = NodeClass.create(TrustedBoxedValue.class);
        @Node.Input
        protected ValueNode value;

        public TrustedBoxedValue(ValueNode value) {
            super((NodeClass<? extends FloatingNode>)TYPE, value.stamp(NodeView.DEFAULT));
            this.value = value;
        }

        public ValueNode getValue() {
            return this.value;
        }

        @Override
        public void lower(LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                this.replaceAtAllUsages(this.value, true);
            }
        }

        @Override
        public Node canonical(CanonicalizerTool tool) {
            if (tool.allUsagesAvailable() && this.hasNoUsages()) {
                return this.value;
            }
            return this;
        }

        @Override
        public void virtualize(VirtualizerTool tool) {
            ValueNode alias = tool.getAlias(this.value);
            if (alias instanceof VirtualObjectNode) {
                tool.replaceWith(alias);
            }
        }
    }
}

