/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.BeginStateSplitNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryProxyNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class CaptureStateBeginNode
extends BeginStateSplitNode
implements Canonicalizable {
    public static final NodeClass<CaptureStateBeginNode> TYPE = NodeClass.create(CaptureStateBeginNode.class);

    public CaptureStateBeginNode() {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.stateAfter() == null) {
            return new BeginNode();
        }
        return this;
    }

    @Override
    public boolean verify() {
        Node node = this.predecessor();
        if (node instanceof LoopExitNode) {
            LoopExitNode loopExit = (LoopExitNode)node;
            assert (loopExit.usages().stream().allMatch(NodePredicates.isA(ValueProxyNode.class).or(MemoryProxyNode.class))) : String.format("LoopExit has disallowed usages %s", loopExit);
        }
        return super.verify();
    }
}

