/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.DeoptBciSupplier;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

public interface ForeignCall
extends LIRLowerable,
DeoptimizingNode.DeoptDuring,
MultiMemoryKill,
StateSplit,
DeoptBciSupplier {
    public NodeInputList<ValueNode> getArguments();

    @Override
    public void setBci(int var1);

    public ForeignCallDescriptor getDescriptor();

    @Override
    default public LocationIdentity[] getKilledLocationIdentities() {
        return this.getDescriptor().getKilledLocations();
    }

    default public Value[] operands(NodeLIRBuilderTool gen) {
        Value[] operands = new Value[this.getArguments().size()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = gen.operand((Node)this.getArguments().get(i));
        }
        return operands;
    }

    @Override
    default public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring;
        if (!1.$assertionsDisabled && this.stateDuring() != null) {
            throw new AssertionError();
        }
        if (currentStateAfter.stackSize() > 0 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 1) == this || currentStateAfter.stackSize() > 1 && currentStateAfter.stackAt(currentStateAfter.stackSize() - 2) == this) {
            if (!1.$assertionsDisabled && this.bci() == -5) {
                throw new AssertionError(this);
            }
            newStateDuring = currentStateAfter.duplicateModified(currentStateAfter.graph(), this.bci(), FrameState.StackState.AfterPop, this.asNode().getStackKind(), null, null, null);
        } else {
            newStateDuring = currentStateAfter;
        }
        this.setStateDuring(newStateDuring);
    }

    @Override
    default public boolean canDeoptimize() {
        return this.getDescriptor().canDeoptimize();
    }

    default public boolean isGuaranteedSafepoint() {
        return this.getDescriptor().isGuaranteedSafepoint();
    }

    @Override
    default public void generate(NodeLIRBuilderTool gen) {
        gen.emitForeignCall(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

